/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.entity.FrostcrawlerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class FrostcrawlerProtoAbilityProcedure {
    private static final String FREEZE_COOLDOWN_TAG = "FrostcrawlerFreezeCooldown";
    private static final String SNOW_BUCKET_COOLDOWN_TAG = "FrostcrawlerSnowBucketCooldown";
    private static final int FREEZE_COOLDOWN = 1200;
    private static final int SNOW_BUCKET_COOLDOWN = 2400;
    private static final int FREEZE_RADIUS = 2;
    private static final ResourceLocation POWDER_SNOW_SOUND = new ResourceLocation("minecraft:item.bucket.fill_powder_snow");
    private static final ResourceLocation FROSTCRAWLER_IMPACT_SOUND = new ResourceLocation("slugterra:frostcrawler_impact");
    private static final ResourceLocation COOLDOWN_SOUND = new ResourceLocation("slugterra:slug_fail");

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof FrostcrawlerEntity)) {
            return;
        }
        FrostcrawlerEntity frostcrawler = (FrostcrawlerEntity)entity;
        Player player = event.getEntity();
        if (player == null || event.getHand() != player.m_7655_() || !player.m_21205_().m_41619_() && player.m_21205_().m_41720_() != Items.f_42446_) {
            return;
        }
        if (!player.m_9236_().m_5776_()) {
            FrostcrawlerProtoAbilityProcedure.execute(frostcrawler, player);
        }
    }

    private static void execute(FrostcrawlerEntity frostcrawler, Player player) {
        boolean frozeWater;
        if (!frostcrawler.m_21824_() || frostcrawler.m_269323_() != player) {
            return;
        }
        Level world = frostcrawler.m_9236_();
        BlockPos entityPos = frostcrawler.m_20183_();
        CompoundTag protoTag = frostcrawler.getPersistentData().m_128469_("proto");
        long currentTime = frostcrawler.m_9236_().m_46467_();
        String frostcrawlerName = frostcrawler.m_7755_().getString();
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() == Items.f_42446_) {
            long lastSnowBucketTime = protoTag.m_128454_(SNOW_BUCKET_COOLDOWN_TAG);
            if (currentTime - lastSnowBucketTime < 2400L) {
                FrostcrawlerProtoAbilityProcedure.sendCooldownMessage(player, frostcrawlerName, "snow bucket", 2400L - (currentTime - lastSnowBucketTime));
                FrostcrawlerProtoAbilityProcedure.playSound((LevelAccessor)world, entityPos, COOLDOWN_SOUND, 0.7f);
                return;
            }
            protoTag.m_128356_(SNOW_BUCKET_COOLDOWN_TAG, currentTime);
            frostcrawler.getPersistentData().m_128365_("proto", (Tag)protoTag);
            heldItem.m_41774_(1);
            if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_151055_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_151055_), false);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\u2744 \u00a7b" + frostcrawlerName + "\u00a7f creates a Powdered Snow Bucket!")), true);
            FrostcrawlerProtoAbilityProcedure.playSound((LevelAccessor)world, entityPos, POWDER_SNOW_SOUND, 1.0f);
            FrostcrawlerProtoAbilityProcedure.spawnParticles((LevelAccessor)world, entityPos);
            return;
        }
        long lastFreezeTime = protoTag.m_128454_(FREEZE_COOLDOWN_TAG);
        if (currentTime - lastFreezeTime < 1200L) {
            FrostcrawlerProtoAbilityProcedure.sendCooldownMessage(player, frostcrawlerName, "freeze", 1200L - (currentTime - lastFreezeTime));
            FrostcrawlerProtoAbilityProcedure.playSound((LevelAccessor)world, entityPos, COOLDOWN_SOUND, 0.7f);
            return;
        }
        if (world.m_8055_(entityPos).m_60734_() == Blocks.f_49990_) {
            frostcrawler.m_6021_(frostcrawler.m_20185_(), frostcrawler.m_20186_() + 1.0, frostcrawler.m_20189_());
        }
        if (!(frozeWater = FrostcrawlerProtoAbilityProcedure.freezeNearbyWater((LevelAccessor)world, entityPos))) {
            player.m_5661_((Component)Component.m_237113_((String)("\u2744 \u00a7f" + frostcrawlerName + " \u00a7bcouldn't find any water to freeze!")), true);
            return;
        }
        protoTag.m_128356_(FREEZE_COOLDOWN_TAG, currentTime);
        frostcrawler.getPersistentData().m_128365_("proto", (Tag)protoTag);
        FrostcrawlerProtoAbilityProcedure.playSound((LevelAccessor)world, entityPos, FROSTCRAWLER_IMPACT_SOUND, 0.5f);
        FrostcrawlerProtoAbilityProcedure.spawnParticles((LevelAccessor)world, entityPos);
        FrostcrawlerProtoAbilityProcedure.runCommand((Entity)frostcrawler);
        player.m_5661_((Component)Component.m_237113_((String)("\u2744 \u00a7b" + frostcrawlerName + "\u00a7f freezes the water around it!")), true);
    }

    private static boolean freezeNearbyWater(LevelAccessor world, BlockPos centerPos) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        boolean frozeAnyWater = false;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BlockPos targetPos = centerPos.m_7918_(dx, dy, dz);
                    if (!world.m_45933_(null, new AABB(targetPos)).isEmpty() || serverWorld.m_8055_(targetPos).m_60734_() != Blocks.f_49990_) continue;
                    serverWorld.m_7731_(targetPos, Blocks.f_50126_.m_49966_(), 3);
                    frozeAnyWater = true;
                }
            }
        }
        return frozeAnyWater;
    }

    private static void sendCooldownMessage(Player player, String slugName, String abilityName, long remainingTicks) {
        long remainingSeconds = remainingTicks / 20L;
        player.m_5661_((Component)Component.m_237113_((String)("\u23f3 \u00a7f" + slugName + " \u00a7bneeds " + remainingSeconds + " more seconds before using " + abilityName + " again!")), true);
    }

    private static void playSound(LevelAccessor world, BlockPos pos, ResourceLocation soundId, float volume) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundId);
            if (soundEvent != null) {
                serverWorld.m_5594_(null, pos, soundEvent, SoundSource.NEUTRAL, volume, 1.0f);
            }
        }
    }

    private static void spawnParticles(LevelAccessor world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175821_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private static void runCommand(Entity entity) {
        if (entity.m_20194_() != null) {
            entity.m_20194_().m_129892_().m_230957_(entity.m_20203_(), "photon fx photon:proto_ice entity @s");
        }
    }
}

