/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GiveTheTouristBeneathOurFeetAdvancementProcedure {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] BIOME_ADVANCEMENTS = new String[]{"slugterra:spectro_biome_advancement", "slugterra:brightworm_biome_advancement", "slugterra:azure_forest_biome_advancement", "slugterra:cavern_biome_advancement", "slugterra:snowdance_biome_advancement", "slugterra:arid_biome_advancement", "slugterra:arachna_biome_advancement", "slugterra:grandmaster_biome_advancement", "slugterra:igneous_biome_advancement"};
    private static final int CHECK_INTERVAL = 100;
    private static final String TOURIST_ADVANCEMENT = "slugterra:the_tourist_beneath_our_feet";

    public static void execute(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.f_19797_ % 100 != 0) {
            return;
        }
        try {
            if (GiveTheTouristBeneathOurFeetAdvancementProcedure.hasAdvancement(serverPlayer, TOURIST_ADVANCEMENT)) {
                return;
            }
            boolean allBiomesCompleted = true;
            for (String biomeAdvId : BIOME_ADVANCEMENTS) {
                if (GiveTheTouristBeneathOurFeetAdvancementProcedure.hasAdvancement(serverPlayer, biomeAdvId)) continue;
                allBiomesCompleted = false;
                break;
            }
            if (allBiomesCompleted) {
                GiveTheTouristBeneathOurFeetAdvancementProcedure.grantAdvancementViaCommand(serverPlayer);
                LOGGER.info("Awarded The Tourist Beneath Our Feet to {} via command", (Object)serverPlayer.m_7755_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking/granting advancements", (Throwable)e);
        }
    }

    private static boolean hasAdvancement(ServerPlayer player, String advancementId) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(advancementId));
        if (advancement == null) {
            LOGGER.warn("Missing advancement: {}", (Object)advancementId);
            return false;
        }
        return player.m_8960_().m_135996_(advancement).m_8193_();
    }

    private static void grantAdvancementViaCommand(ServerPlayer player) {
        CommandSourceStack commandSource = player.m_20203_().m_81325_(2);
        String command = String.format("advancement grant %s only %s", player.m_36316_().getName(), TOURIST_ADVANCEMENT);
        player.m_20194_().m_129892_().m_230957_(commandSource, command);
    }
}

