/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.entity.BoonDocEntity;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GreenBoonDocProtoAbilityProcedure {
    private static final String ACTIVE_TAG = "BoonDocHealingActive";
    private static final String COOLDOWN_TAG = "BoonDocHealingCooldown";
    private static final int DURATION_TICKS = 1200;
    private static final int COOLDOWN_TICKS = 1200;
    private static final int HEAL_INTERVAL = 200;
    private static final float HEAL_AMOUNT = 4.0f;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getHand() != event.getEntity().m_7655_() || !event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        GreenBoonDocProtoAbilityProcedure.execute(event.getTarget(), (Entity)event.getEntity());
    }

    private static void execute(Entity entity, Entity sourceentity) {
        String boonDocName;
        if (entity == null || sourceentity == null || !(entity instanceof BoonDocEntity)) {
            return;
        }
        BoonDocEntity boonDoc = (BoonDocEntity)entity;
        LivingEntity owner = boonDoc.m_269323_();
        if (owner == null || owner != sourceentity) {
            return;
        }
        CompoundTag protoTag = boonDoc.getPersistentData().m_128469_("proto");
        long currentTime = boonDoc.m_9236_().m_46467_();
        long lastUsedTime = protoTag.m_128454_(COOLDOWN_TAG);
        boolean isActive = protoTag.m_128471_(ACTIVE_TAG);
        String string = boonDocName = boonDoc.m_8077_() ? boonDoc.m_7755_().getString() : "BoonDoc";
        if (!isActive && currentTime < lastUsedTime) {
            if (sourceentity instanceof Player) {
                Player player = (Player)sourceentity;
                long remainingSeconds = (lastUsedTime - currentTime) / 20L;
                player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)(boonDocName + " ")).m_130938_(style -> style.m_178520_(0x228B22))).m_7220_((Component)Component.m_237113_((String)("needs " + remainingSeconds + " more seconds to recover!")).m_130938_(style -> style.m_178520_(0x90EE90))), true);
                boonDoc.m_9236_().m_5594_(null, boonDoc.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        protoTag.m_128379_(ACTIVE_TAG, !isActive);
        if (!isActive) {
            protoTag.m_128356_(COOLDOWN_TAG, currentTime + 1200L);
            if (sourceentity instanceof Player) {
                Player player = (Player)sourceentity;
                player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udc9a ").m_7220_((Component)Component.m_237113_((String)(boonDocName + " ")).m_130938_(style -> style.m_178520_(0x228B22))).m_7220_((Component)Component.m_237113_((String)"started healing nearby allies!").m_130938_(style -> style.m_178520_(0x90EE90))), true);
            }
        } else {
            protoTag.m_128356_(COOLDOWN_TAG, currentTime + 1200L);
            if (sourceentity instanceof Player) {
                Player player = (Player)sourceentity;
                player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udc94 ").m_7220_((Component)Component.m_237113_((String)(boonDocName + " ")).m_130938_(style -> style.m_178520_(0x228B22))).m_7220_((Component)Component.m_237113_((String)"stopped healing.").m_130938_(style -> style.m_178520_(11403055))), true);
            }
        }
        boonDoc.getPersistentData().m_128365_("proto", (Tag)protoTag);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            for (Entity entity : level.m_142646_().m_142273_()) {
                String boonDocName;
                if (!(entity instanceof BoonDocEntity)) continue;
                BoonDocEntity boonDoc = (BoonDocEntity)entity;
                CompoundTag protoTag = boonDoc.getPersistentData().m_128469_("proto");
                long currentTime = boonDoc.m_9236_().m_46467_();
                boolean isActive = protoTag.m_128471_(ACTIVE_TAG);
                long cooldownEnd = protoTag.m_128454_(COOLDOWN_TAG);
                String string = boonDocName = boonDoc.m_8077_() ? boonDoc.m_7755_().getString() : "BoonDoc";
                if (isActive && currentTime >= cooldownEnd) {
                    protoTag.m_128379_(ACTIVE_TAG, false);
                    protoTag.m_128356_(COOLDOWN_TAG, currentTime + 1200L);
                    boonDoc.getPersistentData().m_128365_("proto", (Tag)protoTag);
                    LivingEntity livingEntity = boonDoc.m_269323_();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udc94 ").m_7220_((Component)Component.m_237113_((String)(boonDocName + " ")).m_130938_(style -> style.m_178520_(0x228B22))).m_7220_((Component)Component.m_237113_((String)"finished healing cycle.").m_130938_(style -> style.m_178520_(11403055))), true);
                    }
                }
                if (!isActive || currentTime % 200L != 0L) continue;
                GreenBoonDocProtoAbilityProcedure.healNearbyAllies(boonDoc);
            }
        }
    }

    private static void healNearbyAllies(BoonDocEntity boonDoc) {
        double radius = 8.0;
        LivingEntity owner = boonDoc.m_269323_();
        if (owner == null) {
            return;
        }
        for (Entity nearby : boonDoc.m_9236_().m_45933_((Entity)boonDoc, boonDoc.m_20191_().m_82400_(radius))) {
            TamableAnimal pet;
            LivingEntity livingEntity;
            if (!(nearby instanceof LivingEntity) || (livingEntity = (LivingEntity)nearby) != owner && (!(nearby instanceof TamableAnimal) || !(pet = (TamableAnimal)nearby).m_21830_(owner)) || !(livingEntity.m_21223_() < livingEntity.m_21233_())) continue;
            livingEntity.m_5634_(4.0f);
            GreenBoonDocProtoAbilityProcedure.playHealingEffect((Entity)livingEntity);
        }
    }

    private static void playHealingEffect(Entity entity) {
        if (!entity.m_9236_().m_5776_() && entity.m_20194_() != null) {
            entity.m_20194_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, entity.m_20182_(), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, 4, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity), "photon fx photon:boon_doc_healing entity @s");
        }
    }
}

