/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugterraMod;
import falconnex.legendsofslugterra.entity.HoprockEntity;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class HoprockProtoAbilityProcedure {
    private static final Random RANDOM = new Random();
    private static final String COOLDOWN_TAG = "HoprockCooldown";
    private static final int COOLDOWN_TICKS = 600;
    private static final String JUMPING_TAG = "HoprockJumping";
    private static final double JUMP_POWER = 1.2;
    private static final float EXPLOSION_POWER = 1.5f;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        HoprockEntity hoprock;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getHand() != event.getEntity().m_7655_() || !event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof HoprockEntity && (hoprock = (HoprockEntity)entity).m_21824_()) {
            HoprockProtoAbilityProcedure.execute(event.getTarget(), (Entity)event.getEntity());
        }
    }

    public static void execute(Entity entity, Entity sourceentity) {
        CompoundTag protoTag;
        if (!(entity instanceof HoprockEntity)) {
            return;
        }
        HoprockEntity hoprock = (HoprockEntity)entity;
        if (hoprock.m_21824_() && hoprock.m_269323_() != sourceentity) {
            return;
        }
        Level world = hoprock.m_9236_();
        if (hoprock.m_21824_()) {
            long cooldownEnd;
            protoTag = hoprock.getPersistentData().m_128469_("proto");
            long currentTime = world.m_46467_();
            if (currentTime < (cooldownEnd = protoTag.m_128454_(COOLDOWN_TAG))) {
                if (sourceentity instanceof Player) {
                    Player player = (Player)sourceentity;
                    long remainingSeconds = (cooldownEnd - currentTime) / 20L;
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7e\u23f3 Hoprock needs " + remainingSeconds + " more seconds!")).m_130940_(ChatFormatting.GOLD), true);
                    world.m_5594_(null, hoprock.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.NEUTRAL, 0.7f, 1.0f);
                }
                return;
            }
        }
        HoprockProtoAbilityProcedure.startExplosiveJump(hoprock, sourceentity, (LevelAccessor)world);
        if (hoprock.m_21824_()) {
            protoTag = hoprock.getPersistentData().m_128469_("proto");
            protoTag.m_128356_(COOLDOWN_TAG, world.m_46467_() + 600L);
            hoprock.getPersistentData().m_128365_("proto", (Tag)protoTag);
        }
    }

    private static void startExplosiveJump(HoprockEntity hoprock, Entity owner, LevelAccessor world) {
        hoprock.getPersistentData().m_128379_(JUMPING_TAG, true);
        hoprock.setAnimation("explode");
        BlockPos pos = hoprock.m_20183_();
        if (world instanceof Level) {
            Level level = (Level)world;
            level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.5f, Level.ExplosionInteraction.NONE);
        }
        world.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.8f, 1.2f);
        hoprock.m_20256_(new Vec3((RANDOM.nextDouble() - 0.5) * 0.2, 1.2, (RANDOM.nextDouble() - 0.5) * 0.2));
        hoprock.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0, false, false));
        hoprock.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0, false, false));
        SlugterraMod.queueServerWork(5, () -> HoprockProtoAbilityProcedure.monitorJump(hoprock, world, 0));
    }

    private static void monitorJump(HoprockEntity hoprock, LevelAccessor world, int ticks) {
        if (!hoprock.getPersistentData().m_128471_(JUMPING_TAG)) {
            return;
        }
        if (Math.abs(hoprock.m_20184_().f_82480_) < 0.01 && hoprock.m_20096_()) {
            HoprockProtoAbilityProcedure.completeJump(hoprock, world);
            return;
        }
        if (ticks > 200) {
            HoprockProtoAbilityProcedure.completeJump(hoprock, world);
            return;
        }
        SlugterraMod.queueServerWork(5, () -> HoprockProtoAbilityProcedure.monitorJump(hoprock, world, ticks + 5));
    }

    private static void completeJump(HoprockEntity hoprock, LevelAccessor world) {
        hoprock.getPersistentData().m_128473_(JUMPING_TAG);
        hoprock.setAnimation("idle");
        world.m_5594_(null, hoprock.m_20183_(), SoundEvents.f_12447_, SoundSource.NEUTRAL, 0.7f, 1.0f);
        hoprock.m_21195_(MobEffects.f_19607_);
        hoprock.m_21195_(MobEffects.f_19591_);
    }
}

