/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.HypnogrifEntity;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HypnogrifProtoAbilityProcedure {
    private static final String ABILITY_TAG = "HypnogrifAbilityActive";
    private static final double EFFECT_RADIUS = 10.0;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getHand() != event.getEntity().m_7655_() || !event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        HypnogrifProtoAbilityProcedure.executeToggle(event.getTarget(), (Entity)event.getEntity());
    }

    private static void executeToggle(Entity entity, Entity playerEntity) {
        HypnogrifEntity hypnogrif;
        block9: {
            block8: {
                if (!(entity instanceof HypnogrifEntity)) break block8;
                hypnogrif = (HypnogrifEntity)entity;
                if (playerEntity instanceof Player) break block9;
            }
            return;
        }
        Player player = (Player)playerEntity;
        if (!hypnogrif.m_21824_()) {
            return;
        }
        Level world = hypnogrif.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        CompoundTag protoTag = hypnogrif.getPersistentData().m_128469_("proto");
        boolean isActive = protoTag.m_128471_(ABILITY_TAG);
        String hypnogrifName = hypnogrif.m_5446_().getString();
        protoTag.m_128379_(ABILITY_TAG, !isActive);
        hypnogrif.getPersistentData().m_128365_("proto", (Tag)protoTag);
        if (isActive) {
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udca4 \u00a7e" + hypnogrifName + " \u00a7fdeactivates its hypnotic aura...")), true);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)("\u2728 \u00a7b" + hypnogrifName + " \u00a7factivates its mesmerizing gaze!")), true);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                HypnogrifProtoAbilityProcedure.spawnActivationParticles(serverLevel, hypnogrif);
            }
            world.m_6263_(null, hypnogrif.m_20185_(), hypnogrif.m_20186_(), hypnogrif.m_20189_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        player.m_21011_(player.m_7655_(), true);
    }

    private static void spawnActivationParticles(ServerLevel world, HypnogrifEntity entity) {
        for (int i = 0; i < 15; ++i) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_() + (world.f_46441_.m_188500_() - 0.5) * 2.0, entity.m_20186_() + world.f_46441_.m_188500_() * 2.0, entity.m_20189_() + (world.f_46441_.m_188500_() - 0.5) * 2.0, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        boolean isActive;
        HypnogrifEntity hypnogrif;
        Level world;
        block7: {
            block6: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof HypnogrifEntity)) break block6;
                hypnogrif = (HypnogrifEntity)entity;
                if (!world.m_5776_()) break block7;
            }
            return;
        }
        CompoundTag protoTag = hypnogrif.getPersistentData().m_128469_("proto");
        boolean bl = isActive = hypnogrif.m_21824_() ? protoTag.m_128471_(ABILITY_TAG) : true;
        if (isActive) {
            HypnogrifProtoAbilityProcedure.applyHypnoticEffect(world, hypnogrif);
        }
    }

    private static void applyHypnoticEffect(Level world, HypnogrifEntity hypnogrif) {
        for (LivingEntity nearbyEntity : world.m_45976_(LivingEntity.class, hypnogrif.m_20191_().m_82400_(10.0))) {
            if (nearbyEntity instanceof HypnogrifEntity || nearbyEntity.m_21023_((MobEffect)SlugterraModMobEffects.SLUGGY.get())) continue;
            nearbyEntity.m_7292_(new MobEffectInstance((MobEffect)SlugterraModMobEffects.SLUGGY.get(), 100, 0, false, false));
        }
    }

    @SubscribeEvent
    public static void onEntityRemoved(EntityLeaveLevelEvent event) {
        HypnogrifEntity hypnogrif;
        block3: {
            block2: {
                Entity entity = event.getEntity();
                Level world = event.getLevel();
                if (!(entity instanceof HypnogrifEntity)) break block2;
                hypnogrif = (HypnogrifEntity)entity;
                if (!world.m_5776_()) break block3;
            }
            return;
        }
        CompoundTag protoTag = hypnogrif.getPersistentData().m_128469_("proto");
        protoTag.m_128379_(ABILITY_TAG, false);
        hypnogrif.getPersistentData().m_128365_("proto", (Tag)protoTag);
    }
}

