/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.InfurnusYellowEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class InfurnusYellowProtoAbilityProcedure {
    private static final int DURATION_TICKS = 100;
    private static final int COOLDOWN_TICKS = 100;
    private static final String ABILITY_TAG = "InfurnusYellowAbilityActive";
    private static final String COOLDOWN_TAG = "InfurnusYellowCooldown";
    private static final TagKey<Item> MEAT_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("slugterra", "meat"));
    private static final TagKey<Item> LOG_ITEMS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("minecraft", "logs"));

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        InfurnusYellowEntity infurnus;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof InfurnusYellowEntity) || !(infurnus = (InfurnusYellowEntity)entity).m_21824_()) {
            return;
        }
        if (event.getHand() != event.getEntity().m_7655_()) {
            return;
        }
        Level world = infurnus.m_9236_();
        Player player = event.getEntity();
        ItemStack itemstack = event.getItemStack();
        CompoundTag nbt = infurnus.getPersistentData();
        long currentTime = world.m_46467_();
        long lastUsedTime = nbt.m_128454_(COOLDOWN_TAG);
        if (nbt.m_128441_(COOLDOWN_TAG) && currentTime - lastUsedTime < 100L) {
            player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)"Infurnus Yellow needs to cool down!").m_130940_(ChatFormatting.GOLD)), true);
            world.m_5594_(null, infurnus.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        if (itemstack.m_41619_()) {
            InfurnusYellowProtoAbilityProcedure.triggerPhotonCommand(world, infurnus);
            nbt.m_128356_(ABILITY_TAG, currentTime + 100L);
            nbt.m_128356_(COOLDOWN_TAG, currentTime);
            player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237113_((String)"Infurnus Yellow's fiery aura activated!").m_130940_(ChatFormatting.GOLD)), true);
            world.m_5594_(null, infurnus.m_20183_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (itemstack.m_204117_(MEAT_ITEMS)) {
            InfurnusYellowProtoAbilityProcedure.cookMeat(player, itemstack);
            InfurnusYellowProtoAbilityProcedure.playEffects(world, infurnus.m_20183_(), true);
            nbt.m_128356_(COOLDOWN_TAG, currentTime);
        } else if (itemstack.m_204117_(LOG_ITEMS)) {
            InfurnusYellowProtoAbilityProcedure.convertToCharcoal(player, itemstack);
            InfurnusYellowProtoAbilityProcedure.playEffects(world, infurnus.m_20183_(), false);
            nbt.m_128356_(COOLDOWN_TAG, currentTime);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        InfurnusYellowEntity infurnus;
        Level world;
        block11: {
            block10: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof InfurnusYellowEntity)) break block10;
                infurnus = (InfurnusYellowEntity)entity;
                if (!world.m_5776_()) break block11;
            }
            return;
        }
        CompoundTag nbt = infurnus.getPersistentData();
        long currentTime = world.m_46467_();
        if (nbt.m_128441_(ABILITY_TAG) && currentTime < nbt.m_128454_(ABILITY_TAG)) {
            AABB area = new AABB(infurnus.m_20183_()).m_82400_(1.5);
            List entities = world.m_6443_(LivingEntity.class, area, e -> e != infurnus);
            for (LivingEntity target : entities) {
                target.m_20254_(3);
            }
        } else if (nbt.m_128441_(ABILITY_TAG)) {
            nbt.m_128473_(ABILITY_TAG);
            if (infurnus.m_269323_() instanceof Player) {
                Player player = (Player)infurnus.m_269323_();
                player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237113_((String)"Infurnus Yellow's fiery aura has faded!").m_130940_(ChatFormatting.GOLD)), true);
                world.m_5594_(null, infurnus.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private static void triggerPhotonCommand(Level world, InfurnusYellowEntity infurnus) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, infurnus.m_20182_(), infurnus.m_20155_(), serverWorld, 4, infurnus.m_7755_().getString(), infurnus.m_5446_(), serverWorld.m_7654_(), (Entity)infurnus), "photon fx photon:infurnus_yellow_proto entity @s");
        }
    }

    private static void cookMeat(Player player, ItemStack itemstack) {
        ItemStack cooked;
        String itemName;
        switch (itemName = itemstack.m_41720_().toString().toLowerCase()) {
            case "beef": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42580_);
                break;
            }
            case "porkchop": 
            case "pork": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42486_);
                break;
            }
            case "chicken": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42582_);
                break;
            }
            case "mutton": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42659_);
                break;
            }
            case "rabbit": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42698_);
                break;
            }
            case "cod": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42530_);
                break;
            }
            case "salmon": {
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42531_);
                break;
            }
            default: {
                ItemStack itemStack = cooked = itemstack;
            }
        }
        if (!itemstack.m_41619_()) {
            itemstack.m_41774_(1);
            if (!player.m_150109_().m_36054_(cooked)) {
                player.m_36176_(cooked, false);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76\ud83d\udd25 Infurnus Yellow cooked the meat!").m_130940_(ChatFormatting.GOLD), true);
        }
    }

    private static void convertToCharcoal(Player player, ItemStack itemstack) {
        if (!itemstack.m_41619_()) {
            itemstack.m_41774_(1);
            ItemStack charcoal = new ItemStack((ItemLike)Items.f_42414_, 1);
            if (!player.m_150109_().m_36054_(charcoal)) {
                player.m_36176_(charcoal, false);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76\ud83d\udd25 Infurnus Yellow converted the log to charcoal!").m_130940_(ChatFormatting.GOLD), true);
        }
    }

    private static void playEffects(Level world, BlockPos pos, boolean isMeat) {
        world.m_5594_(null, pos, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (isMeat) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 15, 0.3, 0.1, 0.3, 0.05);
            } else {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.3, 0.1, 0.3, 0.05);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.2, 0.2, 0.2, 0.02);
            }
        }
    }
}

