/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.MakobreakerEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MakobreakerProtoAbilityProcedure {
    private static final String CARRIED_ITEM_KEY = "MakobreakerCarriedItem";
    private static final String TARGET_ITEM_KEY = "MakobreakerTargetItem";
    private static final double PICKUP_RANGE = 8.0;
    private static final double DROP_RANGE = 2.0;
    private static final double GRAB_RANGE = 1.5;

    @SubscribeEvent
    public static void onItemDropped(ItemTossEvent event) {
        ItemEntity itemEntity = event.getEntity();
        Level world = itemEntity.m_9236_();
        if (world.m_5776_() || !MakobreakerProtoAbilityProcedure.isItemAllowed(itemEntity.m_32055_())) {
            return;
        }
        AABB area = new AABB(itemEntity.m_20183_()).m_82400_(8.0);
        for (MakobreakerEntity makobreaker : world.m_45976_(MakobreakerEntity.class, area)) {
            if (!makobreaker.m_21824_() || MakobreakerProtoAbilityProcedure.isCarryingItem(makobreaker)) continue;
            MakobreakerProtoAbilityProcedure.setTargetItem(makobreaker, itemEntity);
            break;
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        MakobreakerEntity makobreaker;
        block14: {
            block13: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof MakobreakerEntity)) break block13;
                makobreaker = (MakobreakerEntity)livingEntity;
                if (!event.getEntity().m_9236_().m_5776_()) break block14;
            }
            return;
        }
        Level world = makobreaker.m_9236_();
        if (MakobreakerProtoAbilityProcedure.isCarryingItem(makobreaker)) {
            Player owner;
            ItemEntity carriedItem = MakobreakerProtoAbilityProcedure.getCarriedItem(makobreaker, world);
            if (carriedItem == null || !carriedItem.m_6084_()) {
                MakobreakerProtoAbilityProcedure.clearCarriedItem(makobreaker, world);
                return;
            }
            carriedItem.m_6034_(makobreaker.m_20185_(), makobreaker.m_20186_() + 0.5, makobreaker.m_20189_());
            carriedItem.m_32010_(Integer.MAX_VALUE);
            carriedItem.m_20242_(true);
            LivingEntity livingEntity = makobreaker.m_269323_();
            if (livingEntity instanceof Player && (double)makobreaker.m_20270_((Entity)(owner = (Player)livingEntity)) < 2.0) {
                MakobreakerProtoAbilityProcedure.dropCarriedItem(makobreaker, world);
                if (owner != null) {
                    owner.m_5661_((Component)Component.m_237113_((String)"\ud83d\udce6 ").m_7220_((Component)Component.m_237113_((String)"Makobreaker dropped your item!").m_130940_(ChatFormatting.GOLD)), true);
                }
            }
        } else {
            ItemEntity targetItem = MakobreakerProtoAbilityProcedure.getTargetItem(makobreaker, world);
            if (targetItem != null && targetItem.m_6084_()) {
                makobreaker.m_21573_().m_5624_((Entity)targetItem, 1.0);
                if ((double)makobreaker.m_20270_((Entity)targetItem) < 1.5) {
                    MakobreakerProtoAbilityProcedure.setCarriedItem(makobreaker, targetItem, world);
                    MakobreakerProtoAbilityProcedure.setTargetItem(makobreaker, null);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        MakobreakerEntity makobreaker;
        block6: {
            block5: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                Entity entity = event.getTarget();
                if (!(entity instanceof MakobreakerEntity)) break block5;
                makobreaker = (MakobreakerEntity)entity;
                if (!event.getLevel().m_5776_() && event.getEntity().m_21205_().m_41619_()) break block6;
            }
            return;
        }
        if (MakobreakerProtoAbilityProcedure.isCarryingItem(makobreaker)) {
            MakobreakerProtoAbilityProcedure.dropCarriedItem(makobreaker, makobreaker.m_9236_());
            Player player = event.getEntity();
            player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udce6 ").m_7220_((Component)Component.m_237113_((String)"Makobreaker dropped the item!").m_130940_(ChatFormatting.GOLD)), true);
        }
    }

    private static void dropCarriedItem(MakobreakerEntity makobreaker, Level world) {
        ItemEntity carriedItem = MakobreakerProtoAbilityProcedure.getCarriedItem(makobreaker, world);
        if (carriedItem != null) {
            carriedItem.m_8127_();
            carriedItem.m_32010_(0);
            carriedItem.m_20242_(false);
            MakobreakerProtoAbilityProcedure.clearCarriedItem(makobreaker, world);
            world.m_5594_(null, makobreaker.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static boolean isCarryingItem(MakobreakerEntity makobreaker) {
        return makobreaker.getPersistentData().m_128441_(CARRIED_ITEM_KEY);
    }

    private static ItemEntity getCarriedItem(MakobreakerEntity makobreaker, Level world) {
        CompoundTag data = makobreaker.getPersistentData();
        if (data.m_128441_(CARRIED_ITEM_KEY)) {
            return (ItemEntity)((ServerLevel)world).m_8791_(data.m_128342_(CARRIED_ITEM_KEY));
        }
        return null;
    }

    private static void setCarriedItem(MakobreakerEntity makobreaker, ItemEntity itemEntity, Level world) {
        CompoundTag data = makobreaker.getPersistentData();
        if (itemEntity != null) {
            data.m_128362_(CARRIED_ITEM_KEY, itemEntity.m_20148_());
            itemEntity.m_20329_((Entity)makobreaker);
            world.m_5594_(null, makobreaker.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            data.m_128473_(CARRIED_ITEM_KEY);
        }
    }

    private static void clearCarriedItem(MakobreakerEntity makobreaker, Level world) {
        CompoundTag data = makobreaker.getPersistentData();
        if (data.m_128441_(CARRIED_ITEM_KEY)) {
            Entity entity = ((ServerLevel)world).m_8791_(data.m_128342_(CARRIED_ITEM_KEY));
            if (entity != null) {
                entity.m_8127_();
                entity.m_146884_(makobreaker.m_20182_());
                ((ItemEntity)entity).m_32010_(0);
                ((ItemEntity)entity).m_20242_(false);
            }
            data.m_128473_(CARRIED_ITEM_KEY);
        }
    }

    private static ItemEntity getTargetItem(MakobreakerEntity makobreaker, Level world) {
        CompoundTag data = makobreaker.getPersistentData();
        if (data.m_128441_(TARGET_ITEM_KEY)) {
            return (ItemEntity)((ServerLevel)world).m_8791_(data.m_128342_(TARGET_ITEM_KEY));
        }
        return null;
    }

    private static void setTargetItem(MakobreakerEntity makobreaker, ItemEntity itemEntity) {
        CompoundTag data = makobreaker.getPersistentData();
        if (itemEntity != null) {
            data.m_128362_(TARGET_ITEM_KEY, itemEntity.m_20148_());
        } else {
            data.m_128473_(TARGET_ITEM_KEY);
        }
    }

    private static boolean isItemAllowed(ItemStack itemStack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return itemId == null || !itemId.equals((Object)new ResourceLocation("slugterra", "empty_capsule")) && !itemId.equals((Object)new ResourceLocation("slugterra", "slug_bowl")) && itemStack.m_41720_() != Items.f_42655_ && itemStack.m_41720_() != Items.f_42656_;
    }
}

