/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.NegashadeEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class NegashadeProtoAbilityProcedure {
    private static final int DEFAULT_COOLDOWN = 600;
    private static final int INVISIBILITY_DURATION = 300;
    private static final double RADIUS = 1.0;
    private static final double WILD_TRIGGER_CHANCE = 5.0E-4;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        long lastUsedTime;
        NegashadeEntity negashade;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        if (!(entity instanceof NegashadeEntity) || !(negashade = (NegashadeEntity)entity).m_21824_()) {
            return;
        }
        if (!player.m_21205_().m_41619_()) {
            return;
        }
        Level world = negashade.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        CompoundTag persistentData = negashade.getPersistentData();
        CompoundTag protoData = persistentData.m_128441_("proto") ? persistentData.m_128469_("proto") : new CompoundTag();
        long currentTime = world.m_46467_();
        if (currentTime - (lastUsedTime = protoData.m_128454_("cooldown")) < 600L) {
            int remaining = (int)((600L - (currentTime - lastUsedTime)) / 20L);
            player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)("Negashade needs " + remaining + "s to cloak again!")).m_130940_(ChatFormatting.DARK_GRAY)), true);
            world.m_6263_(null, negashade.m_20185_(), negashade.m_20186_(), negashade.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        UUID ownerUUID = negashade.m_21805_();
        if (ownerUUID == null) {
            return;
        }
        NegashadeProtoAbilityProcedure.triggerPhotonCommand(world, negashade);
        negashade.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300, 0, false, false));
        AABB area = new AABB(negashade.m_20183_()).m_82400_(1.0);
        List entities = world.m_45976_(LivingEntity.class, area);
        for (LivingEntity target : entities) {
            TamableAnimal tamable;
            if (!(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).m_21824_() || !ownerUUID.equals(tamable.m_21805_()) || target.m_21023_(MobEffects.f_19609_)) continue;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300, 0, false, false));
        }
        protoData.m_128356_("cooldown", currentTime);
        persistentData.m_128365_("proto", (Tag)protoData);
        world.m_5594_(null, negashade.m_20183_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udc7b ").m_7220_((Component)Component.m_237113_((String)"Negashade cloaked nearby slugs!").m_130940_(ChatFormatting.GRAY)), true);
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        NegashadeEntity negashade;
        Level world;
        block7: {
            block6: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof NegashadeEntity)) break block6;
                negashade = (NegashadeEntity)entity;
                if (!world.m_5776_()) break block7;
            }
            return;
        }
        if (!negashade.m_21824_() && world.m_213780_().m_188500_() < 5.0E-4 && !negashade.m_21023_(MobEffects.f_19609_)) {
            NegashadeProtoAbilityProcedure.triggerPhotonCommand(world, negashade);
            negashade.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300, 0, false, false));
            world.m_5594_(null, negashade.m_20183_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 0.5f, 1.8f);
        }
    }

    private static void triggerPhotonCommand(Level world, NegashadeEntity negashade) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, negashade.m_20182_(), negashade.m_20155_(), serverWorld, 4, negashade.m_7755_().getString(), negashade.m_5446_(), serverWorld.m_7654_(), (Entity)negashade), "photon fx photon:negashade_proto entity @s");
        }
    }
}

