/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.RammstoneEntity;
import falconnex.legendsofslugterra.init.SlugterraModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class RammstoneProtoAbilityProcedure {
    private static final String MAD_MODE_TAG = "RammstoneMadMode";
    private static final String TARGET_SLUG_TAG = "RammstoneTargetSlug";
    private static final int SEARCH_RADIUS = 5;
    private static final Random RANDOM = new Random();
    private static final int DEFAULT_COOLDOWN = 1200;
    private static final TagKey<EntityType<?>> SLUG_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("slugterra", "slug"));

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        RammstoneEntity rammstone;
        Level world;
        block9: {
            block8: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                Entity entity = event.getTarget();
                world = event.getLevel();
                if (!(entity instanceof RammstoneEntity)) break block8;
                rammstone = (RammstoneEntity)entity;
                if (!world.m_5776_() && rammstone.m_21824_()) break block9;
            }
            return;
        }
        CompoundTag persistentData = rammstone.getPersistentData();
        CompoundTag protoData = persistentData.m_128441_("proto") ? persistentData.m_128469_("proto") : new CompoundTag();
        long currentTime = world.m_46467_();
        long lastUsedTime = protoData.m_128454_("cooldown");
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41720_() == SlugterraModItems.EMPTY_CAPSULE.get() && rammstone.getPersistentData().m_128471_(MAD_MODE_TAG)) {
            rammstone.getPersistentData().m_128379_(MAD_MODE_TAG, false);
            rammstone.setTexture("rammstonetexture1");
            rammstone.setAnimation("empty");
            player.m_5661_((Component)Component.m_237113_((String)"\ud83d\ude0a ").m_7220_((Component)Component.m_237113_((String)"Rammstone calmed down!").m_130940_(ChatFormatting.GREEN)), true);
        } else if (itemStack.m_41619_() && !rammstone.getPersistentData().m_128471_(MAD_MODE_TAG)) {
            if (currentTime - lastUsedTime < 1200L) {
                int remaining = (int)((1200L - (currentTime - lastUsedTime)) / 20L);
                player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)("Rammstone needs " + remaining + "s to get mad again!")).m_130940_(ChatFormatting.RED)), true);
                world.m_5594_(null, rammstone.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.NEUTRAL, 0.7f, 1.0f);
                return;
            }
            rammstone.getPersistentData().m_128379_(MAD_MODE_TAG, true);
            rammstone.setTexture("rammstoneangry");
            protoData.m_128356_("cooldown", currentTime);
            persistentData.m_128365_("proto", (Tag)protoData);
            player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237113_((String)"Rammstone is now in mad mode!").m_130940_(ChatFormatting.RED)), true);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        RammstoneEntity rammstone;
        Level world;
        block15: {
            block14: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof RammstoneEntity)) break block14;
                rammstone = (RammstoneEntity)entity;
                if (!world.m_5776_()) break block15;
            }
            return;
        }
        CompoundTag nbt = rammstone.getPersistentData();
        if (nbt.m_128471_(MAD_MODE_TAG)) {
            if (!nbt.m_128441_(TARGET_SLUG_TAG)) {
                List slugs = world.m_6443_(LivingEntity.class, new AABB(rammstone.m_20183_()).m_82400_(5.0), e -> {
                    TamableAnimal slug;
                    if (!e.m_6095_().m_204039_(SLUG_TAG) || e.equals((Object)rammstone)) {
                        return false;
                    }
                    if (rammstone.m_269323_() != null && e instanceof TamableAnimal && (slug = (TamableAnimal)e).m_269323_() != null) {
                        return !slug.m_269323_().equals((Object)rammstone.m_269323_());
                    }
                    return true;
                });
                if (!slugs.isEmpty()) {
                    LivingEntity targetSlug = (LivingEntity)slugs.get(RANDOM.nextInt(slugs.size()));
                    nbt.m_128362_(TARGET_SLUG_TAG, targetSlug.m_20148_());
                    rammstone.m_6710_(targetSlug);
                }
            } else {
                LivingEntity targetSlug = (LivingEntity)((ServerLevel)world).m_8791_(nbt.m_128342_(TARGET_SLUG_TAG));
                if (targetSlug == null || !targetSlug.m_6084_()) {
                    RammstoneProtoAbilityProcedure.resetRammstone(rammstone);
                    return;
                }
                if ((double)rammstone.m_20270_((Entity)targetSlug) <= 2.0) {
                    rammstone.setAnimation("angry_asf");
                }
            }
        } else if (nbt.m_128441_(TARGET_SLUG_TAG)) {
            nbt.m_128473_(TARGET_SLUG_TAG);
            rammstone.m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void onRammstoneAttack(LivingAttackEvent event) {
        RammstoneEntity rammstone;
        Entity sourceEntity = event.getSource().m_7639_();
        if (sourceEntity instanceof RammstoneEntity && (rammstone = (RammstoneEntity)sourceEntity).getPersistentData().m_128471_(MAD_MODE_TAG)) {
            RammstoneProtoAbilityProcedure.resetRammstone(rammstone);
        }
    }

    private static void resetRammstone(RammstoneEntity rammstone) {
        rammstone.getPersistentData().m_128379_(MAD_MODE_TAG, false);
        rammstone.getPersistentData().m_128473_(TARGET_SLUG_TAG);
        rammstone.setTexture("rammstonetexture1");
        rammstone.setAnimation("empty");
        rammstone.m_6710_(null);
    }
}

