/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.entity.TheDropEntity;
import falconnex.legendsofslugterra.network.SlugterraModVariables;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RidingTheDropProcedure {
    private static final int TELEPORT_DELAY = 60;
    private static ServerPlayer teleportingPlayer = null;
    private static Entity theDropEntity = null;
    private static int countdown = 0;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != event.getEntity().m_7655_()) {
            return;
        }
        RidingTheDropProcedure.execute((Event)event, (LevelAccessor)event.getLevel(), event.getPos().m_123341_(), event.getPos().m_123342_(), event.getPos().m_123343_(), event.getTarget(), (Entity)event.getEntity());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && countdown > 0 && --countdown <= 0 && teleportingPlayer != null && theDropEntity != null) {
            RidingTheDropProcedure.attemptTeleport();
            RidingTheDropProcedure.cleanUp();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, Entity sourceentity) {
        RidingTheDropProcedure.execute(null, world, x, y, z, entity, sourceentity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity, Entity sourceentity) {
        if (entity == null || sourceentity == null || sourceentity instanceof FakePlayer) {
            return;
        }
        if (entity instanceof TheDropEntity && sourceentity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceentity;
            player.m_20329_(entity);
            if (player.m_9236_().m_46472_() == Level.f_46428_ && entity.m_20186_() <= 95.0) {
                player.getCapability(SlugterraModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    capability.PlayerSpawnCarriageOnTravel = true;
                    capability.syncPlayerVariables((Entity)player);
                });
                ((TheDropEntity)entity).setAnimation("2");
                teleportingPlayer = player;
                theDropEntity = entity;
                countdown = 60;
            } else if (sourceentity instanceof Player) {
                ((Player)sourceentity).m_5661_((Component)Component.m_237113_((String)"You're too high up! Get closer to the ground"), true);
            }
        }
    }

    private static void attemptTeleport() {
        if (!RidingTheDropProcedure.validateEntities()) {
            return;
        }
        ServerLevel targetLevel = RidingTheDropProcedure.teleportingPlayer.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("slugterra:the_slugterra")));
        if (targetLevel == null) {
            return;
        }
        BlockPos targetPos = new BlockPos(theDropEntity.m_146903_(), 64, theDropEntity.m_146907_());
        teleportingPlayer.m_8127_();
        teleportingPlayer.m_8999_(targetLevel, (double)targetPos.m_123341_() + 0.5, (double)(targetPos.m_123342_() + 1), (double)targetPos.m_123343_() + 0.5, teleportingPlayer.m_146908_(), teleportingPlayer.m_146909_());
        RidingTheDropProcedure.syncPlayerData();
    }

    private static boolean validateEntities() {
        return teleportingPlayer != null && theDropEntity != null && teleportingPlayer.m_6084_() && theDropEntity.m_6084_() && teleportingPlayer.m_20365_(theDropEntity);
    }

    private static void syncPlayerData() {
        RidingTheDropProcedure.teleportingPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
        RidingTheDropProcedure.teleportingPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(teleportingPlayer.m_150110_()));
        for (MobEffectInstance effect : teleportingPlayer.m_21220_()) {
            RidingTheDropProcedure.teleportingPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(teleportingPlayer.m_19879_(), effect));
        }
        RidingTheDropProcedure.teleportingPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
    }

    private static void cleanUp() {
        if (theDropEntity != null && !theDropEntity.m_9236_().m_5776_()) {
            theDropEntity.m_146870_();
        }
        teleportingPlayer = null;
        theDropEntity = null;
    }
}

