/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugItemMapper;
import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.block.SlugRackBlock;
import falconnex.legendsofslugterra.block.entity.SlugRackTileEntity;
import falconnex.legendsofslugterra.init.SlugterraModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SlugRackActivationProcedure {
    public static void execute(Player player, BlockEntity blockEntity) {
        SlugRackTileEntity slugRackEntity = (SlugRackTileEntity)blockEntity;
        boolean isOpened = slugRackEntity.opened;
        BlockPos blockPos = blockEntity.m_58899_();
        CompoundTag blockPosTag = new CompoundTag();
        blockPosTag.m_128405_("x", blockPos.m_123341_());
        blockPosTag.m_128405_("y", blockPos.m_123342_());
        blockPosTag.m_128405_("z", blockPos.m_123343_());
        blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (isOpened) {
                ItemStack capsulesStack = handler.getStackInSlot(16);
                int radius = 20;
                List<Entity> connectedEntities = player.m_9236_().m_45933_(null, new AABB(blockPos.m_7918_(-radius, -radius, -radius), blockPos.m_7918_(radius, radius, radius))).stream().filter(entity -> entity.getPersistentData().m_128441_("linkedBlockPos") && entity.getPersistentData().m_128454_("linkedBlockPos") == blockPos.m_121878_()).toList();
                if (capsulesStack.m_41613_() >= connectedEntities.size()) {
                    slugRackEntity.opened = false;
                    Level level = player.m_9236_();
                    if (level.m_8055_(blockPos).m_60734_() instanceof SlugRackBlock) {
                        level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)SlugRackBlock.ANIMATION, (Comparable)Integer.valueOf(3)), 3);
                        SoundEvent closeSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugrack_closing"));
                        level.m_5594_(null, blockPos, closeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    for (int i = 0; i < connectedEntities.size(); ++i) {
                        Entity entity2 = connectedEntities.get(i);
                        RegistryObject<Item> entityCapsuleObject = SlugItemMapper.GetCapsuleFromEntity(entity2);
                        if (entityCapsuleObject == null) continue;
                        CompoundTag existingData = new CompoundTag();
                        entity2.m_20223_(existingData);
                        ItemStack filledCapsule = new ItemStack((ItemLike)entityCapsuleObject.get());
                        CompoundTag entityData = new CompoundTag();
                        CompoundTag forgeData = new CompoundTag();
                        entityData.m_128359_("id", existingData.m_128461_("id"));
                        entityData.m_128405_("DataDamage", existingData.m_128451_("DataDamage"));
                        entityData.m_128405_("DataKnockback", existingData.m_128451_("DataKnockback"));
                        entityData.m_128405_("DataSpeed", existingData.m_128451_("DataSpeed"));
                        if (entity2.m_8077_()) {
                            entityData.m_128365_("CustomName", (Tag)StringTag.m_129297_((String)("{\"text\":\"" + entity2.m_7770_().getString() + "\"}")));
                        }
                        entityData.m_128350_("Health", ((LivingEntity)entity2).m_21223_());
                        if (entity2.getPersistentData().m_128441_("variables")) {
                            entityData.m_128365_("variables", entity2.getPersistentData().m_128423_("variables"));
                            forgeData.m_128365_("variables", entity2.getPersistentData().m_128423_("variables"));
                        }
                        if (entity2.getPersistentData().m_128441_("proto")) {
                            entityData.m_128365_("proto", entity2.getPersistentData().m_128423_("proto"));
                            forgeData.m_128365_("proto", entity2.getPersistentData().m_128423_("proto"));
                        }
                        entityData.m_128365_("ForgeData", (Tag)forgeData);
                        filledCapsule.m_41784_().m_128365_("entityData", (Tag)entityData);
                        if (entity2.m_8077_()) {
                            filledCapsule.m_41714_((Component)Component.m_237113_((String)entity2.m_7755_().getString()));
                        }
                        CompoundTag variablesTag = SlugStorage.GetEntityVariables(entityData);
                        CompoundTag displayTag = filledCapsule.m_41698_("display");
                        ListTag lore = new ListTag();
                        for (String key : variablesTag.m_128431_()) {
                            Tag tag = variablesTag.m_128423_(key);
                            if (tag == null) continue;
                            String tagText = tag.toString();
                            if (tag instanceof DoubleTag) {
                                double value = ((DoubleTag)tag).m_7061_();
                                tagText = String.format("%.0f", value);
                            }
                            String loreText = "{\"text\":\"" + key + ": " + tagText + "\",\"color\":\"green\"}";
                            lore.add((Object)StringTag.m_129297_((String)loreText));
                        }
                        displayTag.m_128365_("Lore", (Tag)lore);
                        ItemStack remaining = filledCapsule.m_41777_();
                        for (int slot = 0; slot < handler.getSlots() - 1 && !(remaining = handler.insertItem(slot, remaining, false)).m_41619_(); ++slot) {
                        }
                        if (!remaining.m_41619_()) {
                            ItemEntity capsuleEntity = new ItemEntity(player.m_9236_(), (double)blockPos.m_123341_() + 0.5, (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_() + 0.5, remaining);
                            capsuleEntity.m_32010_(10);
                            player.m_9236_().m_7967_((Entity)capsuleEntity);
                        }
                        capsulesStack.m_41774_(1);
                        entity2.m_146870_();
                    }
                    player.m_5661_((Component)Component.m_237113_((String)"Closing Rack"), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"Rack does not have enough capsules!"), true);
                }
            } else {
                int emptyCapsulesCount = 0;
                player.m_5661_((Component)Component.m_237113_((String)"Opening Rack"), true);
                slugRackEntity.opened = true;
                Level level = player.m_9236_();
                if (level.m_8055_(blockPos).m_60734_() instanceof SlugRackBlock) {
                    level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)SlugRackBlock.ANIMATION, (Comparable)Integer.valueOf(1)), 3);
                    SoundEvent openSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slugrack_opening"));
                    level.m_5594_(null, blockPos, openSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                for (int i = 0; i < handler.getSlots(); ++i) {
                    EntityType<?> entityType;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || (entityType = SlugItemMapper.GetEntityFromCapsule(stack.m_41720_())) == null) continue;
                    Entity entity3 = entityType.m_20615_(player.m_9236_());
                    if (stack.m_41782_() && stack.m_41783_().m_128441_("entityData")) {
                        CompoundTag entityData = stack.m_41783_().m_128469_("entityData");
                        entity3.m_20258_(entityData);
                    }
                    entity3.getPersistentData().m_128356_("linkedBlockPos", blockPos.m_121878_());
                    if (entity3 instanceof TamableAnimal) {
                        TamableAnimal tamableEntity = (TamableAnimal)entity3;
                        tamableEntity.m_21828_(player);
                    }
                    entity3.m_6027_((double)blockPos.m_123341_() + 0.5, (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_() + 0.5);
                    player.m_9236_().m_7967_(entity3);
                    double angle = new Random().nextDouble() * 2.0 * Math.PI;
                    double impulseX = Math.cos(angle) * 0.5;
                    double impulseZ = Math.sin(angle) * 0.5;
                    entity3.m_20334_(impulseX, 0.0, impulseZ);
                    if (handler instanceof IItemHandlerModifiable) {
                        IItemHandlerModifiable modHandler = (IItemHandlerModifiable)handler;
                        modHandler.setStackInSlot(i, ItemStack.f_41583_);
                    }
                    ++emptyCapsulesCount;
                }
                ItemStack emptyCapsules = new ItemStack((ItemLike)SlugterraModItems.EMPTY_CAPSULE.get(), emptyCapsulesCount);
                SlugRackActivationProcedure.AddStackToBlock(blockEntity, 16, emptyCapsules);
            }
        });
    }

    public static void AddStackToBlock(BlockEntity blockEntity, int slotId, ItemStack stack) {
        blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            ItemStack slotStack = handler.getStackInSlot(slotId);
            ItemStack remainingItems = handler.insertItem(16, stack, false);
            if (!remainingItems.m_41619_()) {
                BlockPos blockPos = blockEntity.m_58899_();
                BlockPos dropPos = blockPos.m_7494_();
                Level world = blockEntity.m_58904_();
                ItemEntity itemEntity = new ItemEntity(world, (double)dropPos.m_123341_(), (double)dropPos.m_123342_(), (double)dropPos.m_123343_(), remainingItems);
                world.m_7967_((Entity)itemEntity);
            }
        });
    }
}

