/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.SpeedstingerEntity;
import falconnex.legendsofslugterra.init.SlugterraModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpeedstingerProtoAbilityProcedure {
    private static final int DEFAULT_COOLDOWN = 12000;
    private static final int FURNACE_SEARCH_RADIUS = 5;
    private static final int COOKING_TIME = 60;
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        int cooldownTicks;
        SpeedstingerEntity speedstinger;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof SpeedstingerEntity) || !(speedstinger = (SpeedstingerEntity)entity).m_21824_()) {
            return;
        }
        if (!event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        Level world = speedstinger.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        CompoundTag persistentData = speedstinger.getPersistentData();
        CompoundTag protoData = persistentData.m_128441_("proto") ? persistentData.m_128469_("proto") : new CompoundTag();
        long currentTime = world.m_46467_();
        long lastUsedTime = protoData.m_128454_("cooldown");
        int n = cooldownTicks = protoData.m_128441_("cooldownTicks") ? protoData.m_128451_("cooldownTicks") : 12000;
        if (currentTime - lastUsedTime < (long)cooldownTicks) {
            if (event.getEntity() instanceof Player) {
                Player player = event.getEntity();
                int remaining = (int)(((long)cooldownTicks - (currentTime - lastUsedTime)) / 20L);
                player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)("Speedstinger needs " + remaining + "s to recharge!")).m_130940_(ChatFormatting.GOLD)), true);
                world.m_5594_(null, speedstinger.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        BlockPos furnacePos = SpeedstingerProtoAbilityProcedure.findLitFurnace(world, speedstinger.m_20183_());
        if (furnacePos == null) {
            if (event.getEntity() instanceof Player) {
                Player player = event.getEntity();
                player.m_5661_((Component)Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237113_((String)"No lit furnace nearby!").m_130940_(ChatFormatting.RED)), true);
                world.m_5594_(null, speedstinger.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        protoData.m_128356_("furnacePos", furnacePos.m_121878_());
        persistentData.m_128365_("proto", (Tag)protoData);
        if (speedstinger instanceof Mob) {
            speedstinger.m_21573_().m_26519_((double)furnacePos.m_123341_(), (double)furnacePos.m_123342_(), (double)furnacePos.m_123343_(), 1.0);
        }
        if (event.getEntity() instanceof Player) {
            Player player = event.getEntity();
            player.m_5661_((Component)Component.m_237113_((String)"\ud83c\udf55 ").m_7220_((Component)Component.m_237113_((String)"Speedstinger is preparing pizza!").m_130940_(ChatFormatting.YELLOW)), true);
            world.m_5594_(null, speedstinger.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static BlockPos findLitFurnace(Level world, BlockPos center) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-5, -5, -5), (BlockPos)center.m_7918_(5, 5, 5))) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() != Blocks.f_50094_ || !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) continue;
            return pos.m_7949_();
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        SpeedstingerEntity speedstinger;
        Level world;
        block17: {
            block16: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof SpeedstingerEntity)) break block16;
                speedstinger = (SpeedstingerEntity)entity;
                if (!world.m_5776_() && speedstinger.m_21824_()) break block17;
            }
            return;
        }
        CompoundTag protoData = speedstinger.getPersistentData().m_128469_("proto");
        if (protoData.m_128441_("furnacePos")) {
            BlockState furnaceState;
            BlockPos furnacePos = BlockPos.m_122022_((long)protoData.m_128454_("furnacePos"));
            if (speedstinger.m_20183_().m_123314_((Vec3i)furnacePos, 1.5) && (furnaceState = world.m_8055_(furnacePos)).m_60734_() == Blocks.f_50094_ && ((Boolean)furnaceState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                if (!protoData.m_128441_("cookingStartTime")) {
                    protoData.m_128356_("cookingStartTime", world.m_46467_());
                    speedstinger.getPersistentData().m_128365_("proto", (Tag)protoData);
                    world.m_5594_(null, speedstinger.m_20183_(), SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    long cookingStartTime = protoData.m_128454_("cookingStartTime");
                    if (world.m_46467_() - cookingStartTime >= 60L) {
                        ServerLevel serverWorld;
                        ItemStack pizzaStack = new ItemStack((ItemLike)SlugterraModItems.RICOCHET_PIZZA.get());
                        if (world instanceof ServerLevel) {
                            serverWorld = (ServerLevel)world;
                            ItemEntity pizzaEntity = new ItemEntity((Level)serverWorld, speedstinger.m_20185_(), speedstinger.m_20186_(), speedstinger.m_20189_(), pizzaStack);
                            pizzaEntity.m_32010_(10);
                            serverWorld.m_7967_((Entity)pizzaEntity);
                            SpeedstingerProtoAbilityProcedure.throwPizzaAtNearestPlayer(world, speedstinger, pizzaEntity);
                        }
                        world.m_5594_(null, speedstinger.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        world.m_5594_(null, speedstinger.m_20183_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f);
                        protoData.m_128356_("cooldown", world.m_46467_());
                        protoData.m_128473_("furnacePos");
                        protoData.m_128473_("cookingStartTime");
                        speedstinger.getPersistentData().m_128365_("proto", (Tag)protoData);
                        if (world instanceof ServerLevel) {
                            serverWorld = (ServerLevel)world;
                            for (int i = 0; i < 10; ++i) {
                                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, speedstinger.m_20185_() + RANDOM.nextDouble() - 0.5, speedstinger.m_20186_() + RANDOM.nextDouble(), speedstinger.m_20189_() + RANDOM.nextDouble() - 0.5, 1, 0.0, 0.0, 0.0, 0.1);
                            }
                        }
                    } else if (world.m_46467_() % 20L == 0L && RANDOM.nextFloat() < 0.3f) {
                        world.m_5594_(null, speedstinger.m_20183_(), SoundEvents.f_11907_, SoundSource.BLOCKS, 0.7f, 0.8f + RANDOM.nextFloat() * 0.4f);
                    }
                }
            }
        }
    }

    private static void throwPizzaAtNearestPlayer(Level world, SpeedstingerEntity speedstinger, ItemEntity pizzaEntity) {
        List players = world.m_45976_(Player.class, new AABB(speedstinger.m_20183_()).m_82400_(10.0));
        if (!players.isEmpty()) {
            Player target = (Player)players.get(0);
            Vec3 direction = target.m_20182_().m_82546_(speedstinger.m_20182_()).m_82541_();
            pizzaEntity.m_20256_(direction.m_82490_(1.5));
        }
    }
}

