/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SpiketrapEntityCollidesInTheBlockProcedure {
    private static final String TRAP_TRIGGERED_KEY = "spikeTrapTriggered";
    private static final String TRAP_POS_KEY = "spikeTrapPosition";
    private static final String TRAP_OCCUPIED_KEY = "spikeTrapOccupied";
    private static final String TRAP_OCCUPIER_KEY = "spikeTrapOccupier";

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        boolean shouldTrigger;
        if (entity == null) {
            return;
        }
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockPos entityBlockPos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
        BlockPos closestPos = new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_());
        if (!pos.equals((Object)closestPos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        if (entity.m_20205_() > 1.5f || entity.m_20206_() > 2.0f) {
            return;
        }
        if (SpiketrapEntityCollidesInTheBlockProcedure.isTrapOccupied(world, pos) && !SpiketrapEntityCollidesInTheBlockProcedure.isCurrentOccupier(world, pos, entity)) {
            return;
        }
        boolean isNewTrap = !pos.equals((Object)SpiketrapEntityCollidesInTheBlockProcedure.getTrapPosition(entity));
        boolean bl = shouldTrigger = isNewTrap || !entity.getPersistentData().m_128471_(TRAP_TRIGGERED_KEY);
        if (shouldTrigger) {
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_6047_()) {
                return;
            }
            SpiketrapEntityCollidesInTheBlockProcedure.setTrapOccupied(world, pos, true);
            SpiketrapEntityCollidesInTheBlockProcedure.setTrapOccupier(world, pos, entity);
            SpiketrapEntityCollidesInTheBlockProcedure.setTrapAnimation(world, pos, state, 2);
            entity.m_6469_(entity.m_269291_().m_269264_(), 3.0f);
            entity.getPersistentData().m_128379_(TRAP_TRIGGERED_KEY, true);
            SpiketrapEntityCollidesInTheBlockProcedure.setTrapPosition(entity, pos);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.m_7654_().execute(() -> SpiketrapEntityCollidesInTheBlockProcedure.setTrapAnimation(world, pos, state, 3));
            }
        }
        if (SpiketrapEntityCollidesInTheBlockProcedure.isCurrentOccupier(world, pos, entity)) {
            SpiketrapEntityCollidesInTheBlockProcedure.immobilizeEntity(entity, pos);
        }
    }

    private static void setTrapAnimation(LevelAccessor world, BlockPos pos, BlockState state, int animationValue) {
        IntegerProperty animationProp;
        Property property = state.m_60734_().m_49965_().m_61081_("animation");
        if (property instanceof IntegerProperty && (animationProp = (IntegerProperty)property).m_6908_().contains(animationValue)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)animationProp, (Comparable)Integer.valueOf(animationValue)), 3);
        }
    }

    private static void immobilizeEntity(Entity entity, BlockPos trapPos) {
        entity.m_20256_(Vec3.f_82478_);
        entity.m_6853_(true);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_20256_(Vec3.f_82478_);
            player.f_20900_ = 0.0f;
            player.f_20902_ = 0.0f;
        }
        Vec3 center = new Vec3((double)trapPos.m_123341_() + 0.5, (double)trapPos.m_123342_(), (double)trapPos.m_123343_() + 0.5);
        entity.m_6034_(center.f_82479_, center.f_82480_, center.f_82481_);
    }

    private static BlockPos getTrapPosition(Entity entity) {
        CompoundTag data = entity.getPersistentData();
        if (data.m_128441_(TRAP_POS_KEY)) {
            int[] posArray = data.m_128465_(TRAP_POS_KEY);
            return new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
        return BlockPos.f_121853_;
    }

    private static void setTrapPosition(Entity entity, BlockPos pos) {
        entity.getPersistentData().m_128385_(TRAP_POS_KEY, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    private static boolean isTrapOccupied(LevelAccessor world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag data = blockEntity.getPersistentData();
            return data.m_128471_(TRAP_OCCUPIED_KEY);
        }
        return false;
    }

    private static void setTrapOccupied(LevelAccessor world, BlockPos pos, boolean occupied) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag data = blockEntity.getPersistentData();
            data.m_128379_(TRAP_OCCUPIED_KEY, occupied);
            blockEntity.m_6596_();
        }
    }

    private static boolean isCurrentOccupier(LevelAccessor world, BlockPos pos, Entity entity) {
        CompoundTag data;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null && (data = blockEntity.getPersistentData()).m_128403_(TRAP_OCCUPIER_KEY)) {
            return data.m_128342_(TRAP_OCCUPIER_KEY).equals(entity.m_20148_());
        }
        return false;
    }

    private static void setTrapOccupier(LevelAccessor world, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag data = blockEntity.getPersistentData();
            data.m_128362_(TRAP_OCCUPIER_KEY, entity.m_20148_());
            blockEntity.m_6596_();
        }
    }
}

