/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugStorage;
import falconnex.legendsofslugterra.entity.TazerlingEntity;
import falconnex.legendsofslugterra.init.SlugterraModMobEffects;
import falconnex.legendsofslugterra.init.SlugterraModSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class TazerlingProtoAbilityProcedure {
    private static final Random RANDOM = new Random();
    private static final double TRIGGER_CHANCE = 0.001;
    private static final int EFFECT_DURATION = 60;
    private static final double RADIUS = 2.0;
    private static final int COOLDOWN_TICKS = 600;
    private static final String COOLDOWN_TAG = "TazerlingCooldown";
    private static final String YELLOW_TINT_TAG = "YellowTint";

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        TazerlingEntity tazerling;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof TazerlingEntity) || !(tazerling = (TazerlingEntity)entity).m_21824_()) {
            return;
        }
        if (!event.getEntity().m_21205_().m_41619_()) {
            return;
        }
        Level world = tazerling.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        CompoundTag nbt = tazerling.getPersistentData();
        long currentTime = world.m_46467_();
        long lastUsedTime = nbt.m_128454_(COOLDOWN_TAG);
        if (nbt.m_128441_(COOLDOWN_TAG) && currentTime - lastUsedTime < 600L) {
            if (event.getEntity() instanceof Player) {
                Player player = event.getEntity();
                player.m_5661_((Component)Component.m_237113_((String)"\u23f3 ").m_7220_((Component)Component.m_237113_((String)"Tazerling is still recharging!").m_130940_(ChatFormatting.GOLD)), true);
                world.m_5594_(null, tazerling.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("slugterra:slug_fail")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        TazerlingProtoAbilityProcedure.triggerPhotonCommand(world, tazerling);
        TazerlingProtoAbilityProcedure.applyElectricShock(world, tazerling);
        nbt.m_128356_(COOLDOWN_TAG, currentTime);
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        TazerlingEntity tazerling;
        Level world;
        block7: {
            block6: {
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                CompoundTag entityData = entity.getPersistentData();
                CompoundTag entityVariables = SlugStorage.GetEntityVariables(entityData);
                if (entityVariables.m_128441_("Thugglet")) {
                    return;
                }
                world = entity.m_9236_();
                if (!(entity instanceof TazerlingEntity)) break block6;
                tazerling = (TazerlingEntity)entity;
                if (!world.m_5776_()) break block7;
            }
            return;
        }
        if (!tazerling.m_21824_() && RANDOM.nextDouble() < 0.001) {
            TazerlingProtoAbilityProcedure.triggerPhotonCommand(world, tazerling);
            TazerlingProtoAbilityProcedure.applyElectricShock(world, tazerling);
        }
        TazerlingProtoAbilityProcedure.handleTextureTint(tazerling);
    }

    private static void triggerPhotonCommand(Level world, TazerlingEntity tazerling) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, tazerling.m_20182_(), tazerling.m_20155_(), serverWorld, 4, tazerling.m_7755_().getString(), tazerling.m_5446_(), serverWorld.m_7654_(), (Entity)tazerling), "photon fx photon:tazerling_proto entity @s");
            world.m_5594_(null, tazerling.m_20183_(), (SoundEvent)SlugterraModSounds.TAZERLING_HIT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    private static void applyElectricShock(Level world, TazerlingEntity tazerling) {
        AABB area = new AABB(tazerling.m_20183_()).m_82400_(2.0);
        List entities = world.m_45976_(LivingEntity.class, area);
        for (LivingEntity target : entities) {
            if (target == tazerling) continue;
            target.m_7292_(new MobEffectInstance((MobEffect)SlugterraModMobEffects.ELECTRIC_SHOCK.get(), 60, 0, false, false));
        }
    }

    private static void handleTextureTint(TazerlingEntity tazerling) {
        if (tazerling.m_21023_((MobEffect)SlugterraModMobEffects.ELECTRIC_SHOCK.get())) {
            tazerling.getPersistentData().m_128379_(YELLOW_TINT_TAG, true);
        } else {
            tazerling.getPersistentData().m_128379_(YELLOW_TINT_TAG, false);
        }
    }
}

