/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TeleportToOverworldFromSlugterraProcedure {
    private static final Random random = new Random();
    private static final int MAX_ATTEMPTS = 20;
    private static final int DEEPEST_Y = -48;
    private static final int SEARCH_RADIUS = 100;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TeleportToOverworldFromSlugterraProcedure.execute((Event)event, (Entity)event.player);
        }
    }

    public static void execute(Entity entity) {
        TeleportToOverworldFromSlugterraProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        if (entity.m_9236_().m_46472_() == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("slugterra:the_slugterra")) && entity.m_20186_() > 126.0 && !player.m_9236_().m_5776_()) {
            ResourceKey destinationType = Level.f_46428_;
            if (player.m_9236_().m_46472_() == destinationType) {
                return;
            }
            ServerLevel overworld = player.f_8924_.m_129880_(destinationType);
            if (overworld != null) {
                BlockPos cavePos = TeleportToOverworldFromSlugterraProcedure.findRandomCavePosition(overworld);
                player.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
                player.m_8999_(overworld, (double)cavePos.m_123341_() + 0.5, (double)(cavePos.m_123342_() + 1), (double)cavePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                for (MobEffectInstance effect : player.m_21220_()) {
                    player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), effect));
                }
                player.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
            }
        }
    }

    private static BlockPos findRandomCavePosition(ServerLevel overworld) {
        BlockPos spawnPos = overworld.m_220360_();
        for (int attempt = 0; attempt < 20; ++attempt) {
            int z;
            int x = spawnPos.m_123341_() + random.nextInt(200) - 100;
            BlockPos cavePos = TeleportToOverworldFromSlugterraProcedure.findSafeVerticalPosition(overworld, x, z = spawnPos.m_123343_() + random.nextInt(200) - 100);
            if (cavePos == null) continue;
            return cavePos;
        }
        return new BlockPos(spawnPos.m_123341_() + random.nextInt(50) - 25, Mth.m_14045_((int)(spawnPos.m_123342_() + random.nextInt(30) - 15), (int)-48, (int)overworld.m_151558_()), spawnPos.m_123343_() + random.nextInt(50) - 25);
    }

    private static BlockPos findSafeVerticalPosition(ServerLevel level, int x, int z) {
        BlockPos pos;
        int startY;
        int y;
        for (y = startY = -48 + random.nextInt(48); y < level.m_151558_(); ++y) {
            pos = new BlockPos(x, y, z);
            if (!TeleportToOverworldFromSlugterraProcedure.isValidCavePosition(level, pos)) continue;
            return pos;
        }
        for (y = startY - 1; y >= -48; --y) {
            pos = new BlockPos(x, y, z);
            if (!TeleportToOverworldFromSlugterraProcedure.isValidCavePosition(level, pos)) continue;
            return pos;
        }
        return null;
    }

    private static boolean isValidCavePosition(ServerLevel level, BlockPos pos) {
        if (!level.m_8055_(pos).m_60795_() || !level.m_8055_(pos.m_7494_()).m_60795_()) {
            return false;
        }
        if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            return false;
        }
        int solidCount = 0;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (level.m_8055_(pos.m_121945_(dir)).m_60795_()) continue;
            ++solidCount;
        }
        return solidCount >= 2;
    }
}

