/*
 * Decompiled with CFR 0.152.
 */
package falconnex.legendsofslugterra.procedures;

import falconnex.legendsofslugterra.SlugterraMod;
import falconnex.legendsofslugterra.init.SlugterraModEntities;
import falconnex.legendsofslugterra.network.SlugterraModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class TheSlugterraPlayerEntersDimensionProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (TheSlugterraPlayerEntersDimensionProcedure.shouldSpawnCarriage(entity)) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                TheSlugterraPlayerEntersDimensionProcedure.createAirPocket(serverLevel, entity.m_20183_());
            }
            SlugterraMod.queueServerWork(20, () -> {
                BlockPos safePos = TheSlugterraPlayerEntersDimensionProcedure.findSafeSpawnPosition(world, x, y, z);
                if (safePos != null) {
                    TheSlugterraPlayerEntersDimensionProcedure.spawnAndMountTheDrop(world, safePos, entity);
                    TheSlugterraPlayerEntersDimensionProcedure.resetCarriageFlag(entity);
                } else {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237113_((String)"Couldn't find safe spot to spawn The Drop!"), true);
                    }
                    TheSlugterraPlayerEntersDimensionProcedure.resetCarriageFlag(entity);
                }
            });
        }
    }

    private static boolean shouldSpawnCarriage(Entity entity) {
        return entity.getCapability(SlugterraModVariables.PLAYER_VARIABLES_CAPABILITY, null).map(cap -> cap.PlayerSpawnCarriageOnTravel).orElse(false);
    }

    private static BlockPos findSafeSpawnPosition(LevelAccessor world, double x, double y, double z) {
        BlockPos testPos;
        int i;
        BlockPos startPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        for (i = 0; i < 10; ++i) {
            testPos = startPos.m_6630_(i);
            if (!TheSlugterraPlayerEntersDimensionProcedure.isPositionSafe(world, testPos)) continue;
            return testPos;
        }
        for (i = 1; i < 10; ++i) {
            testPos = startPos.m_6625_(i);
            if (!TheSlugterraPlayerEntersDimensionProcedure.isPositionSafe(world, testPos)) continue;
            return testPos;
        }
        return null;
    }

    private static boolean isPositionSafe(LevelAccessor world, BlockPos pos) {
        return world.m_46859_(pos) && world.m_46859_(pos.m_7494_()) && world.m_46859_(pos.m_6630_(2));
    }

    private static void spawnAndMountTheDrop(LevelAccessor world, BlockPos pos, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            TheSlugterraPlayerEntersDimensionProcedure.createAirPocket(serverLevel, pos);
            Entity theDrop = ((EntityType)SlugterraModEntities.THE_DROP.get()).m_262496_(serverLevel, pos, MobSpawnType.MOB_SUMMONED);
            if (theDrop != null) {
                theDrop.m_20256_(Vec3.f_82478_);
                entity.m_20329_(theDrop);
            }
        }
    }

    private static void createAirPocket(ServerLevel level, BlockPos centerPos) {
        BlockPos.m_121990_((BlockPos)centerPos.m_7918_(-1, 0, -1), (BlockPos)centerPos.m_7918_(1, 1, 1)).forEach(pos -> {
            if (!level.m_46859_(pos)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        });
    }

    private static void resetCarriageFlag(Entity entity) {
        entity.getCapability(SlugterraModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.PlayerSpawnCarriageOnTravel = false;
            capability.syncPlayerVariables(entity);
        });
    }
}

