/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkManager;
import com.xshards.MessageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AfkCommand
implements CommandExecutor {
    private final AfkManager afkManager;
    private final MessageManager messageManager;

    public AfkCommand(AfkManager afkManager, MessageManager messageManager) {
        this.afkManager = afkManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.get("command.only-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("xshards.use")) {
            player.sendMessage(this.messageManager.get("command.no-permission"));
            return true;
        }
        if (!this.afkManager.getPlugin().getConfig().getBoolean("earning.afk.enabled", true)) {
            player.sendMessage(this.messageManager.get("afk.disabled"));
            return true;
        }
        if (this.afkManager.isAfk(player)) {
            player.sendMessage(this.messageManager.get("afk.already-afk"));
            return true;
        }
        if (this.afkManager.isPendingAfk(player)) {
            player.sendMessage(this.messageManager.get("afk.already-pending"));
            return true;
        }
        this.afkManager.startAfkProcess(player);
        return true;
    }
}

