/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkManager;
import com.xshards.MessageManager;
import com.xshards.utils.ActionBarUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AfkListener
implements Listener {
    private final AfkManager afkManager;
    private final MessageManager messageManager;

    public AfkListener(AfkManager afkManager, MessageManager messageManager) {
        this.afkManager = afkManager;
        this.messageManager = messageManager;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.afkManager.isAfk(player)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.afkManager.getPlugin(), () -> {
                this.afkManager.removeAfkData(player);
                player.sendMessage(this.messageManager.get("afk.removed-on-join"));
            }, 20L);
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase();
        if (this.afkManager.isAfk(player) && !command.startsWith("/quitafk")) {
            player.sendMessage(this.messageManager.get("afk.commands-blocked"));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.afkManager.isAfk(player)) {
            event.setCancelled(true);
            ActionBarUtil.sendActionBar(player, this.messageManager.get("afk.interaction-blocked"));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.afkManager.isAfk(player = (Player)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getDamager() instanceof Player && this.afkManager.isAfk(player = (Player)event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.afkManager.isAfk(player)) {
            this.afkManager.removeAfkData(player);
        }
    }
}

