/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkData;
import com.xshards.DatabaseManager;
import com.xshards.MessageManager;
import com.xshards.Xshards;
import com.xshards.utils.ActionBarUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AfkManager {
    private final Xshards plugin;
    private final Map<UUID, AfkData> afkData;
    private Location afkLocation;
    private final Map<UUID, Long> afkStartTime;
    private final DatabaseManager databaseManager;
    private final Map<UUID, Location> pendingAfkTeleports;
    private final Map<UUID, BukkitRunnable> afkCountdowns;
    private final Map<UUID, BossBar> afkBossBars;
    private final MessageManager messageManager;

    public AfkManager(Xshards plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.afkData = new HashMap<UUID, AfkData>();
        this.afkStartTime = new HashMap<UUID, Long>();
        this.databaseManager = plugin.getDatabaseManager();
        this.pendingAfkTeleports = new HashMap<UUID, Location>();
        this.afkCountdowns = new HashMap<UUID, BukkitRunnable>();
        this.afkBossBars = new HashMap<UUID, BossBar>();
        this.loadAfkLocation();
        this.loadAfkData();
    }

    private void savePlayerLocation(Player player) {
        UUID playerUUID = player.getUniqueId();
        Location loc = player.getLocation();
        try (Connection conn = this.databaseManager.getConnection();){
            String sql = this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO player_locations (uuid, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z), yaw = VALUES(yaw), pitch = VALUES(pitch)" : "INSERT OR REPLACE INTO player_locations (uuid, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, playerUUID.toString());
                stmt.setString(2, loc.getWorld().getName());
                stmt.setDouble(3, loc.getX());
                stmt.setDouble(4, loc.getY());
                stmt.setDouble(5, loc.getZ());
                stmt.setFloat(6, loc.getYaw());
                stmt.setFloat(7, loc.getPitch());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save player location: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Location getStoredPlayerLocation(Player player) {
        UUID playerUUID = player.getUniqueId();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT world, x, y, z, yaw, pitch FROM player_locations WHERE uuid = ?");){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            String worldName = rs.getString("world");
            double x = rs.getDouble("x");
            double y = rs.getDouble("y");
            double z = rs.getDouble("z");
            float yaw = rs.getFloat("yaw");
            float pitch = rs.getFloat("pitch");
            if (worldName == null) return null;
            if (Bukkit.getWorld((String)worldName) == null) return null;
            Location location = new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
            return location;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not get stored player location: " + e.getMessage());
        }
        return null;
    }

    public void loadAfkLocation() {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT world, x, y, z FROM afk_location WHERE id = 1");
             ResultSet rs = stmt.executeQuery();){
            if (rs.next()) {
                String worldName = rs.getString("world");
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                double z = rs.getDouble("z");
                if (worldName != null && Bukkit.getWorld((String)worldName) != null) {
                    this.afkLocation = new Location(Bukkit.getWorld((String)worldName), x, y, z);
                    this.plugin.getLogger().info("Loaded AFK location from database.");
                } else {
                    this.afkLocation = null;
                    this.plugin.getLogger().warning("Could not load AFK location: world not found.");
                }
            } else {
                this.afkLocation = null;
                this.plugin.getLogger().info("No AFK location found in database.");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load AFK location: " + e.getMessage());
            this.afkLocation = null;
        }
    }

    public void removeAfkLocation() {
        this.afkLocation = null;
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM afk_location WHERE id = 1");){
            stmt.executeUpdate();
            this.plugin.getLogger().info("Removed AFK location from database.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not remove AFK location: " + e.getMessage());
        }
    }

    public void saveAfkLocation() {
        if (this.afkLocation != null) {
            try (Connection conn = this.databaseManager.getConnection();){
                String sql = this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO afk_location (id, world, x, y, z) VALUES (1, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z)" : "INSERT OR REPLACE INTO afk_location (id, world, x, y, z) VALUES (1, ?, ?, ?, ?)";
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.setString(1, this.afkLocation.getWorld().getName());
                    stmt.setDouble(2, this.afkLocation.getX());
                    stmt.setDouble(3, this.afkLocation.getY());
                    stmt.setDouble(4, this.afkLocation.getZ());
                    stmt.executeUpdate();
                    this.plugin.getLogger().info("Saved AFK location to database.");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save AFK location: " + e.getMessage());
            }
        }
    }

    public void setAfkLocation(Player player) {
        World world = player.getWorld();
        if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) {
            player.sendMessage(this.messageManager.get("afk.invalid-world"));
            player.sendMessage(this.messageManager.get("afk.invalid-world-info"));
            return;
        }
        this.afkLocation = player.getLocation();
        this.saveAfkLocation();
        player.sendMessage(this.messageManager.get("afk.location-set"));
    }

    public void startAfkProcess(final Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.isAfk(player)) {
            player.sendMessage(this.messageManager.get("afk.already-afk"));
            return;
        }
        if (this.afkLocation == null) {
            player.sendMessage(this.messageManager.get("afk.no-location"));
            return;
        }
        this.savePlayerLocation(player);
        final Location initialLocation = player.getLocation().clone();
        this.pendingAfkTeleports.put(playerUUID, initialLocation);
        final BossBar bossBar = Bukkit.createBossBar((String)this.messageManager.get("afk.teleport-boss-bar"), (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        this.afkBossBars.put(playerUUID, bossBar);
        player.sendMessage(this.messageManager.get("afk.startup-message"));
        BukkitRunnable countdown = new BukkitRunnable(){
            int seconds = 5;

            public void run() {
                if (AfkManager.this.hasPlayerMoved(player, initialLocation)) {
                    player.sendMessage(AfkManager.this.messageManager.get("afk.teleport-cancelled"));
                    AfkManager.this.cancelAfkProcess(player);
                    return;
                }
                bossBar.setProgress((double)this.seconds / 5.0);
                if (this.seconds <= 0) {
                    AfkManager.this.completeAfkProcess(player);
                    this.cancel();
                } else {
                    ActionBarUtil.sendActionBar(player, AfkManager.this.messageManager.get("afk.teleport-countdown").replace("{seconds}", String.valueOf(this.seconds)));
                    --this.seconds;
                }
            }
        };
        countdown.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.afkCountdowns.put(playerUUID, countdown);
    }

    private void completeAfkProcess(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.afkBossBars.containsKey(playerUUID)) {
            this.afkBossBars.get(playerUUID).removeAll();
            this.afkBossBars.remove(playerUUID);
        }
        this.pendingAfkTeleports.remove(playerUUID);
        player.teleport(this.afkLocation);
        player.sendMessage(this.messageManager.get("afk.entered-mode"));
        this.afkData.put(playerUUID, new AfkData());
        this.afkStartTime.put(playerUUID, System.currentTimeMillis());
        try (Connection conn = this.databaseManager.getConnection();){
            String sql = this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO afk_status (uuid, is_afk, start_time) VALUES (?, 1, ?) ON DUPLICATE KEY UPDATE is_afk = 1, start_time = VALUES(start_time)" : "INSERT OR REPLACE INTO afk_status (uuid, is_afk, start_time) VALUES (?, 1, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, playerUUID.toString());
                stmt.setLong(2, System.currentTimeMillis());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not set player AFK status: " + e.getMessage());
        }
        this.startAfkShardEarning(player);
    }

    private void cancelAfkProcess(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.afkCountdowns.containsKey(playerUUID)) {
            this.afkCountdowns.get(playerUUID).cancel();
            this.afkCountdowns.remove(playerUUID);
        }
        if (this.afkBossBars.containsKey(playerUUID)) {
            this.afkBossBars.get(playerUUID).removeAll();
            this.afkBossBars.remove(playerUUID);
        }
        this.pendingAfkTeleports.remove(playerUUID);
    }

    public Location getAfkLocation() {
        return this.afkLocation;
    }

    public Location getLastLocation(Player player) {
        Location storedLocation = this.getStoredPlayerLocation(player);
        return storedLocation != null ? storedLocation : player.getLocation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAfk(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.afkData.containsKey(playerUUID)) {
            return true;
        }
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT is_afk FROM afk_status WHERE uuid = ? AND is_afk = 1");){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return false;
            this.afkData.put(playerUUID, new AfkData());
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error checking AFK status: " + e.getMessage());
        }
        return false;
    }

    public boolean isPendingAfk(Player player) {
        return this.pendingAfkTeleports.containsKey(player.getUniqueId());
    }

    public void loadAfkData() {
        this.afkData.clear();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT uuid, start_time FROM afk_status WHERE is_afk = 1");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                UUID playerUUID = UUID.fromString(rs.getString("uuid"));
                long startTime = rs.getLong("start_time");
                this.afkData.put(playerUUID, new AfkData());
                this.afkStartTime.put(playerUUID, startTime);
            }
            this.plugin.getLogger().info("Loaded AFK data for " + this.afkData.size() + " players.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load AFK data: " + e.getMessage());
        }
    }

    public void removeAfkData(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.afkData.remove(playerUUID);
        this.afkStartTime.remove(playerUUID);
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM afk_status WHERE uuid = ?");){
            stmt.setString(1, playerUUID.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not remove AFK data: " + e.getMessage());
        }
    }

    public void quitAfk(Player player) {
        if (this.isAfk(player)) {
            Location lastLocation = this.getLastLocation(player);
            if (lastLocation != null) {
                player.teleport(lastLocation);
                player.sendMessage(this.messageManager.get("afk.exited-mode"));
            } else {
                player.sendMessage(this.messageManager.get("afk.exited-mode-no-location"));
            }
            this.removeAfkData(player);
        } else if (this.isPendingAfk(player)) {
            this.cancelAfkProcess(player);
            player.sendMessage(this.messageManager.get("afk.teleport-cancelled-manual"));
        } else {
            player.sendMessage(this.messageManager.get("afk.not-in-afk"));
        }
    }

    private void startAfkShardEarning(final Player player) {
        final long afkEarnSeconds = this.plugin.getConfig().getLong("earning.afk.interval", 30L);
        final int afkAmount = this.plugin.getConfig().getInt("earning.afk.amount", 1);
        new BukkitRunnable(){
            int countdown;
            {
                this.countdown = (int)afkEarnSeconds;
            }

            public void run() {
                if (AfkManager.this.isAfk(player) && player.isOnline()) {
                    ActionBarUtil.sendActionBar(player, AfkManager.this.messageManager.get("afk.earn-countdown").replace("{seconds}", String.valueOf(this.countdown)));
                    if (this.countdown <= 0) {
                        AfkManager.this.plugin.getShardManager().addShards(player, afkAmount);
                        player.sendMessage(AfkManager.this.messageManager.get("afk.earned").replace("{amount}", String.valueOf(afkAmount)));
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.5f, 1.0f);
                        this.countdown = (int)afkEarnSeconds;
                    } else {
                        --this.countdown;
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public boolean hasPlayerMoved(Player player, Location initialLocation) {
        Location currentLocation = player.getLocation();
        double distanceSquared = initialLocation.distanceSquared(currentLocation);
        return distanceSquared > 0.01;
    }

    public Xshards getPlugin() {
        return this.plugin;
    }
}

