/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.DatabaseManager;
import com.xshards.MessageManager;
import com.xshards.StreakData;
import com.xshards.Xshards;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class DailyRewardManager {
    private final Xshards plugin;
    private final DatabaseManager databaseManager;
    private final MessageManager messageManager;
    private final Map<UUID, StreakData> streakCache;

    public DailyRewardManager(Xshards plugin, DatabaseManager databaseManager, MessageManager messageManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.messageManager = messageManager;
        this.streakCache = new HashMap<UUID, StreakData>();
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        try (Connection conn = this.databaseManager.getConnection();){
            String sql = this.databaseManager.getStorageType().equals("mysql") ? "CREATE TABLE IF NOT EXISTS daily_rewards (uuid VARCHAR(36) PRIMARY KEY, last_reward_date DATE, streak_days INT DEFAULT 0, multiplier DOUBLE DEFAULT 1.0, stage VARCHAR(20) DEFAULT 'easy')" : "CREATE TABLE IF NOT EXISTS daily_rewards (uuid TEXT PRIMARY KEY, last_reward_date TEXT, streak_days INTEGER DEFAULT 0, multiplier REAL DEFAULT 1.0, stage TEXT DEFAULT 'easy')";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize daily rewards table: " + e.getMessage());
        }
    }

    public void checkAndGiveReward(Player player) {
        if (!this.plugin.getConfig().getBoolean("daily-rewards.enabled", true)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        LocalDate today = LocalDate.now();
        StreakData streakData = this.getStreakData(playerUUID);
        LocalDate lastClaimDate = streakData.getLastLoginDate();
        if (lastClaimDate != null && lastClaimDate.equals(today)) {
            return;
        }
        if (lastClaimDate != null) {
            long daysBetween = ChronoUnit.DAYS.between(lastClaimDate, today);
            if (daysBetween > 1L) {
                streakData.setStreakDays(1);
                streakData.setMultiplier(1.0);
                streakData.setStage("easy");
                player.sendMessage(this.messageManager.get("daily-reward.streak-reset"));
            } else if (daysBetween == 1L) {
                streakData.setStreakDays(streakData.getStreakDays() + 1);
                this.updateMultiplier(streakData);
            }
        } else {
            streakData.setStreakDays(1);
            streakData.setMultiplier(1.0);
            streakData.setStage("easy");
        }
        streakData.setLastLoginDate(today);
        int baseAmount = this.plugin.getConfig().getInt("daily-rewards.amount", 10);
        int finalAmount = (int)((double)baseAmount * streakData.getMultiplier());
        this.plugin.getShardManager().addShards(player, finalAmount);
        String rewardMessage = this.messageManager.get("daily-reward.received").replace("{amount}", String.valueOf(finalAmount));
        player.sendMessage(rewardMessage);
        if (this.plugin.getConfig().getBoolean("daily-rewards.streak.enabled", true)) {
            String streakMessage = this.messageManager.get("daily-reward.streak-active").replace("{days}", String.valueOf(streakData.getStreakDays())).replace("{multiplier}", String.format("%.1f", streakData.getMultiplier())).replace("{stage}", streakData.getStage());
            player.sendMessage(streakMessage);
        }
        this.saveStreakData(playerUUID, streakData);
    }

    private void updateMultiplier(StreakData streakData) {
        if (!this.plugin.getConfig().getBoolean("daily-rewards.streak.enabled", true)) {
            return;
        }
        double increment = this.plugin.getConfig().getDouble("daily-rewards.streak.increment", 0.1);
        String activeStage = this.plugin.getConfig().getString("daily-rewards.streak.active_stage", "easy");
        int interval = activeStage.equalsIgnoreCase("hard") ? this.plugin.getConfig().getInt("daily-rewards.streak.hard.interval", 7) : (activeStage.equalsIgnoreCase("mid") ? this.plugin.getConfig().getInt("daily-rewards.streak.mid.interval", 3) : this.plugin.getConfig().getInt("daily-rewards.streak.easy.interval", 1));
        int streakDays = streakData.getStreakDays();
        double currentMultiplier = streakData.getMultiplier();
        if (streakDays % interval == 0 && streakDays > 0) {
            currentMultiplier += increment;
            streakData.setStage(activeStage);
        }
        streakData.setMultiplier(Math.max(1.0, currentMultiplier));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StreakData getStreakData(UUID playerUUID) {
        if (this.streakCache.containsKey(playerUUID)) {
            return this.streakCache.get(playerUUID);
        }
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT last_reward_date, streak_days, multiplier, stage FROM daily_rewards WHERE uuid = ?");){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String dateStr = rs.getString("last_reward_date");
                int streakDays = rs.getInt("streak_days");
                double multiplier = rs.getDouble("multiplier");
                String stage = rs.getString("stage");
                LocalDate lastDate = dateStr != null ? LocalDate.parse(dateStr) : null;
                StreakData data = new StreakData(streakDays, lastDate, multiplier, stage);
                this.streakCache.put(playerUUID, data);
                StreakData streakData = data;
                return streakData;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error getting streak data: " + e.getMessage());
        }
        StreakData newData = new StreakData();
        this.streakCache.put(playerUUID, newData);
        return newData;
    }

    private void saveStreakData(UUID playerUUID, StreakData data) {
        try (Connection conn = this.databaseManager.getConnection();){
            String sql = this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO daily_rewards (uuid, last_reward_date, streak_days, multiplier, stage) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE last_reward_date = ?, streak_days = ?, multiplier = ?, stage = ?" : "INSERT OR REPLACE INTO daily_rewards (uuid, last_reward_date, streak_days, multiplier, stage) VALUES (?, ?, ?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, playerUUID.toString());
                stmt.setString(2, data.getLastLoginDate() != null ? data.getLastLoginDate().toString() : null);
                stmt.setInt(3, data.getStreakDays());
                stmt.setDouble(4, data.getMultiplier());
                stmt.setString(5, data.getStage());
                if (!this.databaseManager.getStorageType().equals("sqlite")) {
                    stmt.setString(6, data.getLastLoginDate() != null ? data.getLastLoginDate().toString() : null);
                    stmt.setInt(7, data.getStreakDays());
                    stmt.setDouble(8, data.getMultiplier());
                    stmt.setString(9, data.getStage());
                }
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error saving streak data: " + e.getMessage());
        }
    }
}

