/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.Xshards;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class DatabaseManager {
    private final Xshards plugin;
    private Connection connection;
    private String storageType;
    private String host;
    private String database;
    private String username;
    private String password;
    private int port;
    private String sqliteFile;
    private boolean connected = false;
    private boolean connectionLogged = false;

    public DatabaseManager(Xshards plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.connect();
        this.createTables();
    }

    private void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.storageType = config.getString("storage.type", "sqlite").toLowerCase();
        if (this.storageType.equals("mysql")) {
            this.host = config.getString("storage.mysql.host", "localhost");
            this.port = config.getInt("storage.mysql.port", 3306);
            this.database = config.getString("storage.mysql.database", "xshards");
            this.username = config.getString("storage.mysql.user", "root");
            this.password = config.getString("storage.mysql.password", "password");
        } else {
            this.sqliteFile = config.getString("storage.sqlite.file", "plugins/XShards/storage/xshards.db");
        }
    }

    public void connect() {
        try {
            if (this.storageType.equals("mysql")) {
                this.connectToMySQL();
            } else {
                this.connectToSQLite();
            }
            this.connected = true;
            if (!this.connectionLogged) {
                this.plugin.getLogger().info("Successfully connected to " + this.storageType.toUpperCase() + " database");
                this.connectionLogged = true;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to connect to database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToMySQL() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
                this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&autoReconnect=true&useUnicode=true&characterEncoding=UTF-8", this.username, this.password);
            }
            catch (ClassNotFoundException e) {
                this.plugin.getLogger().severe("MySQL JDBC driver not found!");
                throw new SQLException("MySQL JDBC driver not found!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToSQLite() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            try {
                Class.forName("org.sqlite.JDBC");
                File dbFile = new File(this.sqliteFile);
                File parentDir = dbFile.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.sqliteFile);
                try (Statement statement = this.connection.createStatement();){
                    statement.execute("PRAGMA foreign_keys = ON;");
                }
            }
            catch (ClassNotFoundException e) {
                this.plugin.getLogger().severe("SQLite JDBC driver not found!");
                throw new SQLException("SQLite JDBC driver not found!");
            }
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.connected = false;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error closing database connection: " + e.getMessage(), e);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connect();
            return this.connection;
        }
        try {
            if (!this.connection.isValid(1)) {
                this.plugin.getLogger().info("Database connection lost. Reconnecting...");
                this.connect();
            }
        }
        catch (SQLException e) {
            this.connect();
        }
        return this.connection;
    }

    public void createTables() {
        try {
            if (this.storageType.equals("mysql")) {
                this.createMySQLTables();
            } else {
                this.createSQLiteTables();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to create database tables: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createMySQLTables() throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS player_shards (uuid VARCHAR(36) PRIMARY KEY, player_name VARCHAR(16) NOT NULL, shards INT NOT NULL DEFAULT 0) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
            statement.execute("CREATE TABLE IF NOT EXISTS shop_items (slot INT PRIMARY KEY, item_data MEDIUMBLOB NOT NULL, price DOUBLE NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
            statement.execute("CREATE TABLE IF NOT EXISTS afk_location (id INT PRIMARY KEY AUTO_INCREMENT, world VARCHAR(64) NOT NULL, x DOUBLE NOT NULL, y DOUBLE NOT NULL, z DOUBLE NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
            statement.execute("CREATE TABLE IF NOT EXISTS player_locations (uuid VARCHAR(36) PRIMARY KEY, world VARCHAR(64) NOT NULL, x DOUBLE NOT NULL, y DOUBLE NOT NULL, z DOUBLE NOT NULL, yaw FLOAT NOT NULL, pitch FLOAT NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
            statement.execute("CREATE TABLE IF NOT EXISTS afk_status (uuid VARCHAR(36) PRIMARY KEY, is_afk BOOLEAN NOT NULL DEFAULT FALSE, start_time BIGINT) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
        }
    }

    private void createSQLiteTables() throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS player_shards (uuid TEXT PRIMARY KEY, player_name TEXT NOT NULL, shards INTEGER NOT NULL DEFAULT 0);");
            statement.execute("CREATE TABLE IF NOT EXISTS shop_items (slot INTEGER PRIMARY KEY, item_data BLOB NOT NULL, price REAL NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS afk_location (id INTEGER PRIMARY KEY AUTOINCREMENT, world TEXT NOT NULL, x REAL NOT NULL, y REAL NOT NULL, z REAL NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS player_locations (uuid TEXT PRIMARY KEY, world TEXT NOT NULL, x REAL NOT NULL, y REAL NOT NULL, z REAL NOT NULL, yaw REAL NOT NULL, pitch REAL NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS afk_status (uuid TEXT PRIMARY KEY, is_afk INTEGER NOT NULL DEFAULT 0, start_time INTEGER);");
        }
    }

    public static byte[] serializeItemStack(ItemStack item) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);
            dataOutput.writeObject(item.serialize());
            dataOutput.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Failed to serialize ItemStack: " + e.getMessage());
            return new byte[0];
        }
    }

    public static ItemStack deserializeItemStack(byte[] data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            ObjectInputStream dataInput = new ObjectInputStream(inputStream);
            Map serializedItem = (Map)dataInput.readObject();
            dataInput.close();
            return ItemStack.deserialize((Map)serializedItem);
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Failed to deserialize ItemStack: " + e.getMessage());
            return null;
        }
    }

    public String getStorageType() {
        return this.storageType;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

