/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.LeaderboardManager;
import com.xshards.MessageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaderboardCommand
implements CommandExecutor {
    private final LeaderboardManager leaderboardManager;
    private final MessageManager messageManager;

    public LeaderboardCommand(LeaderboardManager leaderboardManager, MessageManager messageManager) {
        this.leaderboardManager = leaderboardManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.get("command.only-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("xshards.leaderboard")) {
            player.sendMessage(this.messageManager.get("command.no-permission"));
            return true;
        }
        int page = 1;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
                if (page < 1) {
                    page = 1;
                }
            }
            catch (NumberFormatException e) {
                page = 1;
            }
        }
        this.leaderboardManager.openLeaderboard(player, page);
        return true;
    }
}

