/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.LeaderboardManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;

public class LeaderboardListener
implements Listener {
    private final LeaderboardManager leaderboardManager;

    public LeaderboardListener(LeaderboardManager leaderboardManager) {
        this.leaderboardManager = leaderboardManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().contains("Shards Leaderboard")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        ItemMeta meta = event.getCurrentItem().getItemMeta();
        String displayName = meta.getDisplayName();
        if (displayName.equals("\u00a7cPrevious Page")) {
            int currentPage = this.extractPageNumber(event.getView().getTitle());
            this.leaderboardManager.openLeaderboard(player, currentPage - 1);
        } else if (displayName.equals("\u00a7aNext Page")) {
            int currentPage = this.extractPageNumber(event.getView().getTitle());
            this.leaderboardManager.openLeaderboard(player, currentPage + 1);
        }
    }

    private int extractPageNumber(String title) {
        try {
            String[] parts = title.split(" ");
            return Integer.parseInt(parts[parts.length - 2]);
        }
        catch (Exception e) {
            return 1;
        }
    }
}

