/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.DatabaseManager;
import com.xshards.MessageManager;
import com.xshards.Xshards;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class LeaderboardManager {
    private final Xshards plugin;
    private final DatabaseManager databaseManager;
    private final MessageManager messageManager;
    private final int itemsPerPage = 7;

    public LeaderboardManager(Xshards plugin, DatabaseManager databaseManager, MessageManager messageManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.messageManager = messageManager;
    }

    public void openLeaderboard(Player player, int page) {
        ItemStack pageInfo;
        ItemMeta pageMeta;
        List<LeaderboardEntry> entries = this.getTopPlayers();
        int totalPages = (entries.size() + 7 - 1) / 7;
        if (page > totalPages) {
            page = totalPages;
        }
        if (page < 1) {
            page = 1;
        }
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)("Shards Leaderboard - Page " + page));
        int startIndex = (page - 1) * 7;
        int endIndex = Math.min(startIndex + 7, entries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            LeaderboardEntry entry = entries.get(i);
            ItemStack skull = this.createPlayerSkull(entry.getPlayerName(), entry.getRank(), entry.getShards());
            inv.addItem(new ItemStack[]{skull});
        }
        if (page > 1) {
            ItemStack prevItem = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevItem.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName("\u00a7cPrevious Page");
                prevItem.setItemMeta(prevMeta);
            }
            inv.setItem(18, prevItem);
        }
        if ((pageMeta = (pageInfo = new ItemStack(Material.PAPER)).getItemMeta()) != null) {
            pageMeta.setDisplayName("\u00a7ePages: " + page + "/" + totalPages);
            pageInfo.setItemMeta(pageMeta);
        }
        inv.setItem(22, pageInfo);
        if (page < totalPages) {
            ItemStack nextItem = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextItem.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName("\u00a7aNext Page");
                nextItem.setItemMeta(nextMeta);
            }
            inv.setItem(26, nextItem);
        }
        player.openInventory(inv);
    }

    private ItemStack createPlayerSkull(String playerName, int rank, int shards) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (skullMeta != null) {
            skullMeta.setOwner(playerName);
            skullMeta.setDisplayName("\u00a76[#" + rank + "] " + playerName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a7eShards: \u00a76" + shards)));
            skullMeta.setLore(lore);
            skull.setItemMeta((ItemMeta)skullMeta);
        }
        return skull;
    }

    private List<LeaderboardEntry> getTopPlayers() {
        ArrayList<LeaderboardEntry> entries = new ArrayList<LeaderboardEntry>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT uuid, player_name, shards FROM player_shards ORDER BY shards DESC LIMIT 100");){
            ResultSet rs = stmt.executeQuery();
            int rank = 1;
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String playerName = rs.getString("player_name");
                int shards = rs.getInt("shards");
                entries.add(new LeaderboardEntry(uuid, playerName, shards, rank));
                ++rank;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error loading leaderboard: " + e.getMessage());
        }
        return entries;
    }

    public static class LeaderboardEntry {
        private final String uuid;
        private final String playerName;
        private final int shards;
        private final int rank;

        public LeaderboardEntry(String uuid, String playerName, int shards, int rank) {
            this.uuid = uuid;
            this.playerName = playerName;
            this.shards = shards;
            this.rank = rank;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getShards() {
            return this.shards;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

