/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.MessageManager;
import com.xshards.ShardManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShardCommand
implements CommandExecutor {
    private final ShardManager shardManager;
    private final MessageManager messageManager;

    public ShardCommand(ShardManager shardManager, MessageManager messageManager) {
        this.shardManager = shardManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
                Player targetPlayer = Bukkit.getPlayer((String)args[1]);
                if (targetPlayer == null) {
                    sender.sendMessage(this.messageManager.get("shards.player-not-found"));
                    return true;
                }
                try {
                    int amount = Integer.parseInt(args[2]);
                    this.shardManager.addShards(targetPlayer, amount);
                    sender.sendMessage(this.messageManager.get("shards.given").replace("{amount}", String.valueOf(amount)).replace("{player}", targetPlayer.getName()));
                    targetPlayer.sendMessage(this.messageManager.get("shards.received").replace("{amount}", String.valueOf(amount)).replace("{sender}", "Console"));
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.messageManager.get("shards.invalid-amount"));
                }
                return true;
            }
            sender.sendMessage(this.messageManager.get("shards.console-usage"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            int playerShards = this.shardManager.getShards(player);
            player.sendMessage(this.messageManager.get("shards.balance").replace("{amount}", String.valueOf(playerShards)));
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("give") && player.hasPermission("xshards.admin")) {
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                player.sendMessage(this.messageManager.get("shards.player-not-found"));
                return true;
            }
            try {
                int amount = Integer.parseInt(args[2]);
                this.shardManager.addShards(targetPlayer, amount);
                player.sendMessage(this.messageManager.get("shards.given").replace("{amount}", String.valueOf(amount)).replace("{player}", targetPlayer.getName()));
                targetPlayer.sendMessage(this.messageManager.get("shards.received").replace("{amount}", String.valueOf(amount)).replace("{sender}", player.getName()));
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.messageManager.get("shards.invalid-amount"));
            }
            return true;
        }
        player.sendMessage(this.messageManager.get("shards.usage"));
        return true;
    }
}

