/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.MessageManager;
import com.xshards.ShardManager;
import com.xshards.Xshards;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ShardListener
implements Listener {
    private final ShardManager shardManager;
    private final Xshards plugin;
    private final MessageManager messageManager;
    private final Map<UUID, Map<UUID, Long>> lastKillTimestamps = new HashMap<UUID, Map<UUID, Long>>();
    private final Map<UUID, Long> lastEarnedTime = new HashMap<UUID, Long>();

    public ShardListener(ShardManager shardManager, Xshards plugin, MessageManager messageManager) {
        this.shardManager = shardManager;
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.startShardEarningTask();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.shardManager.loadPlayerData(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.shardManager.savePlayerData(player);
    }

    private void startShardEarningTask() {
        new BukkitRunnable(){

            public void run() {
                if (!ShardListener.this.plugin.getConfig().getBoolean("earning.playtime.enabled", true)) {
                    return;
                }
                long earnShardTime = ShardListener.this.plugin.getConfig().getLong("earning.playtime.interval", 3600000L);
                int shards = ShardListener.this.plugin.getConfig().getInt("earning.playtime.amount", 3);
                for (Player player : ShardListener.this.plugin.getServer().getOnlinePlayers()) {
                    UUID playerId = player.getUniqueId();
                    long currentTime = System.currentTimeMillis();
                    if (ShardListener.this.lastEarnedTime.containsKey(playerId)) {
                        long lastTime = ShardListener.this.lastEarnedTime.get(playerId);
                        if (currentTime - lastTime < earnShardTime) continue;
                        ShardListener.this.shardManager.addShards(player, shards);
                        player.sendMessage(ShardListener.this.messageManager.get("shards.playtime-earned").replace("{amount}", String.valueOf(shards)));
                        ShardListener.this.lastEarnedTime.put(playerId, currentTime);
                        continue;
                    }
                    ShardListener.this.lastEarnedTime.put(playerId, currentTime);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1200L);
    }

    @EventHandler
    public void onPlayerKill(EntityDeathEvent event) {
        Player killedPlayer;
        Player killer;
        if (!this.plugin.getConfig().getBoolean("earning.kills.enabled", true)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (killer = (killedPlayer = (Player)entity).getKiller()) != null) {
            UUID killerUUID = killer.getUniqueId();
            UUID killedUUID = killedPlayer.getUniqueId();
            long currentTime = System.currentTimeMillis();
            Map killerKillTimestamps = this.lastKillTimestamps.getOrDefault(killerUUID, new HashMap());
            if (!killerKillTimestamps.containsKey(killedUUID) || currentTime - (Long)killerKillTimestamps.get(killedUUID) >= 86400000L) {
                int shardsPerKill = this.plugin.getConfig().getInt("earning.kills.amount", 10);
                this.shardManager.addShards(killer, shardsPerKill);
                killer.sendMessage(this.messageManager.get("shards.kill-earned").replace("{amount}", String.valueOf(shardsPerKill)).replace("{player}", killedPlayer.getName()));
                killerKillTimestamps.put(killedUUID, currentTime);
                this.lastKillTimestamps.put(killerUUID, killerKillTimestamps);
            } else {
                killer.sendMessage(this.messageManager.get("shards.kill-cooldown").replace("{player}", killedPlayer.getName()));
            }
        }
    }
}

