/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.DatabaseManager;
import com.xshards.ShardData;
import com.xshards.ShopItem;
import com.xshards.TransferListener;
import com.xshards.Xshards;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShardManager {
    private final Xshards plugin;
    private final Map<UUID, ShardData> playerData;
    private final Map<UUID, ShopItem> pendingPurchases;
    private final Map<UUID, TransferListener.TransferData> pendingTransfers;
    private final DatabaseManager databaseManager;

    public ShardManager(Xshards plugin) {
        this.plugin = plugin;
        this.playerData = new HashMap<UUID, ShardData>();
        this.pendingPurchases = new HashMap<UUID, ShopItem>();
        this.pendingTransfers = new HashMap<UUID, TransferListener.TransferData>();
        this.databaseManager = plugin.getDatabaseManager();
        this.loadAllPlayerData();
    }

    public void addShards(Player player, int amount) {
        UUID playerUUID = player.getUniqueId();
        ShardData data = this.playerData.getOrDefault(playerUUID, new ShardData());
        data.addShards(amount);
        this.playerData.put(playerUUID, data);
        player.sendMessage("You earned " + amount + " shards!");
        this.savePlayerData(player);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getShards(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.playerData.containsKey(playerUUID)) {
            return this.playerData.get(playerUUID).getShards();
        }
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT shards FROM player_shards WHERE uuid = ?");){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int shards = rs.getInt("shards");
                this.playerData.put(playerUUID, new ShardData(shards));
                int n = shards;
                return n;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error getting player shards: " + e.getMessage());
        }
        this.playerData.put(playerUUID, new ShardData(0));
        return 0;
    }

    public void savePlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName();
        int shards = this.playerData.getOrDefault(playerUUID, new ShardData()).getShards();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO player_shards (uuid, player_name, shards) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE player_name = VALUES(player_name), shards = VALUES(shards)" : "INSERT OR REPLACE INTO player_shards (uuid, player_name, shards) VALUES (?, ?, ?)");){
            stmt.setString(1, playerUUID.toString());
            stmt.setString(2, playerName);
            stmt.setInt(3, shards);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save player data for " + playerName + "!", e);
        }
    }

    public void loadPlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT shards FROM player_shards WHERE uuid = ?");){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int shards = rs.getInt("shards");
                this.playerData.put(playerUUID, new ShardData(shards));
            } else {
                this.playerData.put(playerUUID, new ShardData(0));
                this.savePlayerData(player);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load player data for " + player.getName() + "!", e);
            this.playerData.put(playerUUID, new ShardData(0));
        }
    }

    public void saveAllPlayerData() {
        try (Connection conn = this.databaseManager.getConnection();){
            String sql = this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO player_shards (uuid, player_name, shards) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE player_name = VALUES(player_name), shards = VALUES(shards)" : "INSERT OR REPLACE INTO player_shards (uuid, player_name, shards) VALUES (?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                for (Map.Entry<UUID, ShardData> entry : this.playerData.entrySet()) {
                    UUID playerUUID = entry.getKey();
                    Player player = Bukkit.getPlayer((UUID)playerUUID);
                    if (player == null) continue;
                    stmt.setString(1, playerUUID.toString());
                    stmt.setString(2, player.getName());
                    stmt.setInt(3, entry.getValue().getShards());
                    stmt.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save all player data!", e);
        }
    }

    public void loadAllPlayerData() {
        this.playerData.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadPlayerData(player);
        }
    }

    public void setPendingPurchase(Player player, ShopItem item) {
        this.pendingPurchases.put(player.getUniqueId(), item);
    }

    public ShopItem getPendingPurchase(Player player) {
        return this.pendingPurchases.get(player.getUniqueId());
    }

    public void clearPendingPurchase(Player player) {
        this.pendingPurchases.remove(player.getUniqueId());
    }

    public void initiateTransfer(Player sender, Player recipient, int amount) {
        ItemStack cancelItem;
        ItemMeta cancelMeta;
        Bukkit.createInventory(null, (int)9, (String)"Confirm Transfer");
        Inventory confirmInv = Bukkit.createInventory(null, (int)9, (String)"Confirm Transfer");
        ItemStack confirmItem = new ItemStack(Material.GREEN_WOOL);
        ItemMeta confirmMeta = confirmItem.getItemMeta();
        if (confirmMeta != null) {
            confirmMeta.setDisplayName("\u00a7aConfirm Transfer of " + amount + " shards to " + recipient.getName());
            confirmItem.setItemMeta(confirmMeta);
        }
        if ((cancelMeta = (cancelItem = new ItemStack(Material.RED_WOOL)).getItemMeta()) != null) {
            cancelMeta.setDisplayName("\u00a7cCancel Transfer");
            cancelItem.setItemMeta(cancelMeta);
        }
        confirmInv.setItem(3, confirmItem);
        confirmInv.setItem(5, cancelItem);
        sender.openInventory(confirmInv);
        this.pendingTransfers.put(sender.getUniqueId(), new TransferListener.TransferData(recipient.getUniqueId(), amount));
    }

    public TransferListener.TransferData getPendingTransfer(Player player) {
        return this.pendingTransfers.get(player.getUniqueId());
    }

    public void clearPendingTransfer(Player player) {
        this.pendingTransfers.remove(player.getUniqueId());
    }
}

