/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.MessageManager;
import com.xshards.ShardManager;
import com.xshards.ShopItem;
import com.xshards.ShopManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopListener
implements Listener {
    private final ShopManager shopManager;
    private final ShardManager shardManager;
    private final MessageManager messageManager;

    public ShopListener(ShopManager shopManager, ShardManager shardManager, MessageManager messageManager) {
        this.shopManager = shopManager;
        this.shardManager = shardManager;
        this.messageManager = messageManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Shard Shop")) {
            int slot;
            ShopItem item;
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR && (item = this.shopManager.getItemInShop(slot = event.getSlot())) != null) {
                if ((double)this.shardManager.getShards(player) >= item.getPrice()) {
                    this.openConfirmationGUI(player, item);
                } else {
                    player.sendMessage(this.messageManager.get("shop.insufficient-shards"));
                }
            }
        }
    }

    private void openConfirmationGUI(Player player, ShopItem item) {
        ItemStack cancelItem;
        ItemMeta cancelMeta;
        Inventory confirmationGui = Bukkit.createInventory(null, (int)9, (String)"Confirm Purchase");
        ItemStack confirmItem = new ItemStack(Material.GREEN_WOOL);
        ItemMeta confirmMeta = confirmItem.getItemMeta();
        if (confirmMeta != null) {
            confirmMeta.setDisplayName("\u00a7aConfirm Purchase");
            confirmItem.setItemMeta(confirmMeta);
        }
        if ((cancelMeta = (cancelItem = new ItemStack(Material.RED_WOOL)).getItemMeta()) != null) {
            cancelMeta.setDisplayName("\u00a7cCancel Purchase");
            cancelItem.setItemMeta(cancelMeta);
        }
        confirmationGui.setItem(3, confirmItem);
        confirmationGui.setItem(5, cancelItem);
        player.openInventory(confirmationGui);
        this.shardManager.setPendingPurchase(player, item);
    }

    @EventHandler
    public void onConfirmationClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Confirm Purchase")) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ShopItem pendingItem = this.shardManager.getPendingPurchase(player);
            if (pendingItem != null && event.getCurrentItem() != null) {
                if (event.getCurrentItem().getType() == Material.GREEN_WOOL) {
                    List lore;
                    double price = pendingItem.getPrice();
                    ItemStack purchasedItem = pendingItem.getItem().clone();
                    ItemMeta meta = purchasedItem.getItemMeta();
                    if (meta != null && meta.hasLore() && (lore = meta.getLore()) != null) {
                        lore.removeIf(line -> line.contains("Price:"));
                        meta.setLore(lore);
                        purchasedItem.setItemMeta(meta);
                    }
                    this.shardManager.addShards(player, -((int)price));
                    player.getInventory().addItem(new ItemStack[]{purchasedItem});
                    player.sendMessage(this.messageManager.get("shop.purchase-success").replace("{item}", purchasedItem.getType().toString()).replace("{price}", String.valueOf(price)));
                } else if (event.getCurrentItem().getType() == Material.RED_WOOL) {
                    player.sendMessage(this.messageManager.get("shop.purchase-cancelled"));
                }
                this.shardManager.clearPendingPurchase(player);
                player.closeInventory();
            }
        }
    }
}

