/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.DatabaseManager;
import com.xshards.ShopItem;
import com.xshards.Xshards;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopManager {
    private final Xshards plugin;
    private final Map<Integer, ShopItem> shopItems;
    private final DatabaseManager databaseManager;

    public ShopManager(Xshards plugin) {
        this.plugin = plugin;
        this.shopItems = new HashMap<Integer, ShopItem>();
        this.databaseManager = plugin.getDatabaseManager();
        this.loadShopData();
    }

    public void addItemToShop(int slot, ItemStack item, double price) {
        ItemStack shopItem = item.clone();
        ItemMeta meta = shopItem.getItemMeta();
        if (meta != null) {
            ArrayList<CallSite> lore;
            ArrayList<CallSite> arrayList = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            if (lore == null) {
                lore = new ArrayList<CallSite>();
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + "Price: " + String.valueOf(ChatColor.LIGHT_PURPLE) + price + "$ " + String.valueOf(ChatColor.WHITE) + "Shards")));
            meta.setLore(lore);
            shopItem.setItemMeta(meta);
        }
        this.shopItems.put(slot, new ShopItem(item.clone(), price));
        this.saveShopData();
    }

    public void editItemPrice(int slot, double newPrice) {
        ShopItem existingItem = this.shopItems.get(slot);
        if (existingItem != null) {
            this.shopItems.put(slot, new ShopItem(existingItem.getItem(), newPrice));
            this.saveShopData();
        }
    }

    public void removeItemFromShop(int slot) {
        this.shopItems.remove(slot);
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM shop_items WHERE slot = ?");){
            stmt.setInt(1, slot);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not remove shop item: " + e.getMessage());
        }
    }

    public ShopItem getItemInShop(int slot) {
        return this.shopItems.get(slot);
    }

    public void loadShopData() {
        this.shopItems.clear();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT slot, item_data, price FROM shop_items");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                int slot = rs.getInt("slot");
                byte[] itemData = rs.getBytes("item_data");
                double price = rs.getDouble("price");
                ItemStack item = DatabaseManager.deserializeItemStack(itemData);
                if (item == null) continue;
                this.shopItems.put(slot, new ShopItem(item, price));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load shop data: " + e.getMessage());
        }
    }

    public void saveShopData() {
        try (Connection conn = this.databaseManager.getConnection();){
            String sql = this.databaseManager.getStorageType().equals("mysql") ? "INSERT INTO shop_items (slot, item_data, price) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE item_data = VALUES(item_data), price = VALUES(price)" : "INSERT OR REPLACE INTO shop_items (slot, item_data, price) VALUES (?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                for (Map.Entry<Integer, ShopItem> entry : this.shopItems.entrySet()) {
                    stmt.setInt(1, entry.getKey());
                    stmt.setBytes(2, DatabaseManager.serializeItemStack(entry.getValue().getItem()));
                    stmt.setDouble(3, entry.getValue().getPrice());
                    stmt.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save shop data: " + e.getMessage());
        }
    }

    public void openShopGUI(Player player) {
        int size = this.plugin.getConfig().getInt("store.size", 54);
        size = Math.min(54, Math.max(9, size / 9 * 9));
        Inventory shopInventory = Bukkit.createInventory(null, (int)size, (String)"Shard Shop");
        for (Map.Entry<Integer, ShopItem> entry : this.shopItems.entrySet()) {
            int slot = entry.getKey();
            if (slot >= size) continue;
            ShopItem shopItem = entry.getValue();
            ItemStack displayItem = shopItem.getItem().clone();
            ItemMeta meta = displayItem.getItemMeta();
            if (meta != null) {
                ArrayList<CallSite> lore;
                ArrayList<CallSite> arrayList = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                if (lore == null) {
                    lore = new ArrayList<CallSite>();
                }
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + "Price: " + String.valueOf(ChatColor.LIGHT_PURPLE) + shopItem.getPrice() + "$ " + String.valueOf(ChatColor.WHITE) + "Shards")));
                meta.setLore(lore);
                displayItem.setItemMeta(meta);
            }
            shopInventory.setItem(slot, displayItem);
        }
        player.openInventory(shopInventory);
    }
}

