/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.MessageManager;
import com.xshards.ShardManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransferCommand
implements CommandExecutor {
    private final ShardManager shardManager;
    private final MessageManager messageManager;

    public TransferCommand(ShardManager shardManager, MessageManager messageManager) {
        this.shardManager = shardManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.get("command.only-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("xshards.transfer")) {
            player.sendMessage(this.messageManager.get("command.no-permission"));
            return true;
        }
        if (!Bukkit.getPluginManager().getPlugin("Xshards").getConfig().getBoolean("transfer.enabled", true)) {
            player.sendMessage(this.messageManager.get("transfer.disabled"));
            return true;
        }
        if (args.length != 2) {
            player.sendMessage(this.messageManager.get("transfer.usage"));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args[0]);
        if (targetPlayer == null) {
            player.sendMessage(this.messageManager.get("shards.player-not-found"));
            return true;
        }
        if (targetPlayer.equals((Object)player)) {
            player.sendMessage(this.messageManager.get("transfer.cannot-self"));
            return true;
        }
        try {
            int amount = Integer.parseInt(args[1]);
            if (amount <= 0) {
                player.sendMessage(this.messageManager.get("transfer.invalid-amount"));
                return true;
            }
            int playerShards = this.shardManager.getShards(player);
            if (playerShards < amount) {
                player.sendMessage(this.messageManager.get("transfer.insufficient"));
                return true;
            }
            this.shardManager.initiateTransfer(player, targetPlayer, amount);
            player.sendMessage(this.messageManager.get("transfer.initiated").replace("{player}", targetPlayer.getName()).replace("{amount}", String.valueOf(amount)));
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.messageManager.get("shards.invalid-amount"));
        }
        return true;
    }
}

