/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.MessageManager;
import com.xshards.ShardManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class TransferListener
implements Listener {
    private final ShardManager shardManager;
    private final MessageManager messageManager;
    private final Map<UUID, TransferData> pendingTransfers = new HashMap<UUID, TransferData>();

    public TransferListener(ShardManager shardManager, MessageManager messageManager) {
        this.shardManager = shardManager;
        this.messageManager = messageManager;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals("Confirm Transfer")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        TransferData transfer = this.pendingTransfers.get(player.getUniqueId());
        if (transfer == null || event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getType() == Material.GREEN_WOOL) {
            Player recipient = Bukkit.getPlayer((UUID)transfer.getRecipientUUID());
            if (recipient != null) {
                this.shardManager.addShards(player, -transfer.getAmount());
                this.shardManager.addShards(recipient, transfer.getAmount());
                player.sendMessage(this.messageManager.get("transfer.success-sender").replace("{player}", recipient.getName()).replace("{amount}", String.valueOf(transfer.getAmount())));
                recipient.sendMessage(this.messageManager.get("transfer.success-recipient").replace("{player}", player.getName()).replace("{amount}", String.valueOf(transfer.getAmount())));
            }
        } else if (event.getCurrentItem().getType() == Material.RED_WOOL) {
            player.sendMessage(this.messageManager.get("transfer.cancelled"));
        }
        this.pendingTransfers.remove(player.getUniqueId());
        player.closeInventory();
    }

    public void addPendingTransfer(Player player, TransferData transfer) {
        this.pendingTransfers.put(player.getUniqueId(), transfer);
    }

    public static class TransferData {
        private final UUID recipientUUID;
        private final int amount;

        public TransferData(UUID recipientUUID, int amount) {
            this.recipientUUID = recipientUUID;
            this.amount = amount;
        }

        public UUID getRecipientUUID() {
            return this.recipientUUID;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

