/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkCommand;
import com.xshards.AfkListener;
import com.xshards.AfkManager;
import com.xshards.AfkRemoveCommand;
import com.xshards.DailyRewardListener;
import com.xshards.DailyRewardManager;
import com.xshards.DatabaseManager;
import com.xshards.LeaderboardCommand;
import com.xshards.LeaderboardListener;
import com.xshards.LeaderboardManager;
import com.xshards.MessageManager;
import com.xshards.QuitAfkCommand;
import com.xshards.SetAfkCommand;
import com.xshards.ShardCommand;
import com.xshards.ShardListener;
import com.xshards.ShardManager;
import com.xshards.ShopCommand;
import com.xshards.ShopListener;
import com.xshards.ShopManager;
import com.xshards.TransferCommand;
import com.xshards.TransferListener;
import com.xshards.XshardsCommand;
import com.xshards.XshardsPlaceholder;
import com.xshards.utils.ActionBarUtil;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Xshards
extends JavaPlugin {
    private ShardManager shardManager;
    private ShopManager shopManager;
    private AfkManager afkManager;
    private DatabaseManager databaseManager;
    private MessageManager messageManager;
    private DailyRewardManager dailyRewardManager;
    private LeaderboardManager leaderboardManager;
    private TransferListener transferListener;

    public void onEnable() {
        ActionBarUtil.initialize();
        this.saveDefaultConfig();
        File storageDir = new File(this.getDataFolder(), "storage");
        if (!storageDir.exists()) {
            storageDir.mkdirs();
        }
        this.messageManager = new MessageManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.shardManager = new ShardManager(this);
        this.shopManager = new ShopManager(this);
        this.afkManager = new AfkManager(this, this.messageManager);
        this.dailyRewardManager = new DailyRewardManager(this, this.databaseManager, this.messageManager);
        this.leaderboardManager = new LeaderboardManager(this, this.databaseManager, this.messageManager);
        this.transferListener = new TransferListener(this.shardManager, this.messageManager);
        this.getCommand("shards").setExecutor((CommandExecutor)new ShardCommand(this.shardManager, this.messageManager));
        this.getCommand("store").setExecutor((CommandExecutor)new ShopCommand(this.shopManager, this.messageManager));
        this.getCommand("xshards").setExecutor((CommandExecutor)new XshardsCommand(this, this.messageManager));
        this.getCommand("afk").setExecutor((CommandExecutor)new AfkCommand(this.afkManager, this.messageManager));
        this.getCommand("setafk").setExecutor((CommandExecutor)new SetAfkCommand(this.afkManager, this.messageManager));
        this.getCommand("quitafk").setExecutor((CommandExecutor)new QuitAfkCommand(this.afkManager, this.messageManager));
        this.getCommand("afkremove").setExecutor((CommandExecutor)new AfkRemoveCommand(this.afkManager, this.messageManager));
        this.getCommand("transfer").setExecutor((CommandExecutor)new TransferCommand(this.shardManager, this.messageManager));
        this.getCommand("leaderboard").setExecutor((CommandExecutor)new LeaderboardCommand(this.leaderboardManager, this.messageManager));
        this.getServer().getPluginManager().registerEvents((Listener)new ShardListener(this.shardManager, this, this.messageManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShopListener(this.shopManager, this.shardManager, this.messageManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AfkListener(this.afkManager, this.messageManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DailyRewardListener(this.dailyRewardManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LeaderboardListener(this.leaderboardManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.transferListener, (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new XshardsPlaceholder(this.shardManager).register();
            this.getLogger().info("PlaceholderAPI detected. Shards placeholders registered!");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholders will not be available.");
        }
        try {
            this.databaseManager.getConnection().prepareStatement("DELETE FROM afk_status").executeUpdate();
            this.getLogger().info("AFK status data has been reset on server startup.");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to clear AFK status data: " + e.getMessage());
        }
        this.getLogger().info("Xshards v1.2.2 has been enabled!");
    }

    public void onDisable() {
        if (this.afkManager != null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.afkManager.isAfk(player)) continue;
                this.afkManager.quitAfk(player);
            }
        }
        if (this.shardManager != null) {
            this.shardManager.saveAllPlayerData();
        }
        if (this.shopManager != null) {
            this.shopManager.saveShopData();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("Xshards has been disabled.");
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public AfkManager getAfkManager() {
        return this.afkManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public DailyRewardManager getDailyRewardManager() {
        return this.dailyRewardManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.messageManager.reload();
        String currentStorageType = this.databaseManager.getStorageType();
        String configStorageType = this.getConfig().getString("storage.type", "sqlite");
        if (!currentStorageType.equals(configStorageType)) {
            this.getLogger().info("Storage type changed from " + currentStorageType + " to " + configStorageType + ". Reconnecting...");
            this.databaseManager.close();
            this.databaseManager = new DatabaseManager(this);
            this.shardManager.loadAllPlayerData();
            this.shopManager.loadShopData();
            this.afkManager.loadAfkData();
            this.afkManager.loadAfkLocation();
        }
    }
}

