/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.MessageManager;
import com.xshards.Xshards;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class XshardsCommand
implements CommandExecutor {
    private final Xshards plugin;
    private final MessageManager messageManager;

    public XshardsCommand(Xshards plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("xshards.admin")) {
                    sender.sendMessage(this.messageManager.get("command.no-permission"));
                    return true;
                }
                this.plugin.reloadPlugin();
                sender.sendMessage(this.messageManager.get("xshards.reloaded"));
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            default: {
                sender.sendMessage(this.messageManager.get("xshards.unknown-command"));
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.messageManager.get("xshards.help.header"));
        sender.sendMessage(this.messageManager.get("xshards.help.general-title"));
        sender.sendMessage(this.messageManager.get("xshards.help.general-shards"));
        sender.sendMessage(this.messageManager.get("xshards.help.general-store"));
        sender.sendMessage(this.messageManager.get("xshards.help.general-afk"));
        sender.sendMessage(this.messageManager.get("xshards.help.general-quitafk"));
        sender.sendMessage(this.messageManager.get("xshards.help.shop-title"));
        sender.sendMessage(this.messageManager.get("xshards.help.shop-edit"));
        sender.sendMessage(this.messageManager.get("xshards.help.shop-add"));
        sender.sendMessage(this.messageManager.get("xshards.help.shop-remove"));
        if (sender.hasPermission("xshards.admin")) {
            sender.sendMessage(this.messageManager.get("xshards.help.admin-title"));
            sender.sendMessage(this.messageManager.get("xshards.help.admin-setafk"));
            sender.sendMessage(this.messageManager.get("xshards.help.admin-afkremove"));
            sender.sendMessage(this.messageManager.get("xshards.help.admin-reload"));
            sender.sendMessage(this.messageManager.get("xshards.help.admin-give"));
        }
        sender.sendMessage(this.messageManager.get("xshards.help.earning-title"));
        sender.sendMessage(this.messageManager.get("xshards.help.earning-playtime"));
        sender.sendMessage(this.messageManager.get("xshards.help.earning-pvp"));
        sender.sendMessage(this.messageManager.get("xshards.help.earning-afk"));
        sender.sendMessage(this.messageManager.get("xshards.help.storage-title"));
        sender.sendMessage(this.messageManager.get("xshards.help.storage-current").replace("{type}", this.plugin.getDatabaseManager().getStorageType().toUpperCase()));
        sender.sendMessage(this.messageManager.get("xshards.help.storage-configure"));
        sender.sendMessage(this.messageManager.get("xshards.help.footer"));
    }
}

