/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkManager;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AfkCommand
implements CommandExecutor {
    private final AfkManager afkManager;

    public AfkCommand(AfkManager afkManager) {
        this.afkManager = afkManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be executed by a player.");
            return true;
        }
        final Player player = (Player)sender;
        if (!this.afkManager.getPlugin().getConfig().getBoolean("earning.afk.enabled", true)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "AFK mode is currently disabled.");
            return true;
        }
        if (this.afkManager.isAfk(player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in AFK mode. Use /quitafk to exit.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You will be teleported to the AFK location in 5 seconds. Don't move!");
        final Location initialLocation = player.getLocation();
        new BukkitRunnable(){
            int countdown = 5;

            public void run() {
                if (this.countdown > 0) {
                    player.sendTitle(String.valueOf(ChatColor.GREEN) + "Teleporting in " + this.countdown + " seconds", String.valueOf(ChatColor.YELLOW) + "Don't move!", 10, 20, 10);
                    --this.countdown;
                } else if (AfkCommand.this.afkManager.hasPlayerMoved(player, initialLocation)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Teleportation canceled because you moved.");
                    this.cancel();
                } else {
                    if (AfkCommand.this.afkManager.getAfkLocation() != null) {
                        AfkCommand.this.afkManager.setAfk(player);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You are now in AFK mode.");
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "AFK location is not set. Please set it using /setafk.");
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.afkManager.getPlugin(), 0L, 20L);
        return true;
    }
}

