/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkData;
import com.xshards.Xshards;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AfkManager {
    private final Xshards plugin;
    private final Map<UUID, AfkData> afkData;
    private final File afkDataFile;
    private final File afkLocationFile;
    private final File playerLocationsFile;
    private FileConfiguration afkDataConfig;
    private Location afkLocation;
    private final Map<UUID, Long> afkStartTime;
    private FileConfiguration playerLocationsConfig;

    public AfkManager(Xshards plugin) {
        this.plugin = plugin;
        this.afkData = new HashMap<UUID, AfkData>();
        this.afkStartTime = new HashMap<UUID, Long>();
        this.afkDataFile = new File(plugin.getDataFolder(), "afkdata.yml");
        this.afkLocationFile = new File(plugin.getDataFolder(), "afkmod.yml");
        this.playerLocationsFile = new File(plugin.getDataFolder(), "playerlocations.yml");
        this.loadAfkData();
        this.loadAfkLocation();
        this.loadPlayerLocations();
    }

    private void loadPlayerLocations() {
        if (!this.playerLocationsFile.exists()) {
            try {
                this.playerLocationsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create player locations file: " + e.getMessage());
            }
        }
        this.playerLocationsConfig = YamlConfiguration.loadConfiguration((File)this.playerLocationsFile);
    }

    private void savePlayerLocation(Player player) {
        String path = player.getUniqueId().toString();
        Location loc = player.getLocation();
        this.playerLocationsConfig.set(path + ".world", (Object)loc.getWorld().getName());
        this.playerLocationsConfig.set(path + ".x", (Object)loc.getX());
        this.playerLocationsConfig.set(path + ".y", (Object)loc.getY());
        this.playerLocationsConfig.set(path + ".z", (Object)loc.getZ());
        this.playerLocationsConfig.set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.playerLocationsConfig.set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        try {
            this.playerLocationsConfig.save(this.playerLocationsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save player location: " + e.getMessage());
        }
    }

    private Location getStoredPlayerLocation(Player player) {
        String path = player.getUniqueId().toString();
        if (!this.playerLocationsConfig.contains(path)) {
            return null;
        }
        String worldName = this.playerLocationsConfig.getString(path + ".world");
        if (worldName == null || Bukkit.getWorld((String)worldName) == null) {
            return null;
        }
        double x = this.playerLocationsConfig.getDouble(path + ".x");
        double y = this.playerLocationsConfig.getDouble(path + ".y");
        double z = this.playerLocationsConfig.getDouble(path + ".z");
        float yaw = (float)this.playerLocationsConfig.getDouble(path + ".yaw");
        float pitch = (float)this.playerLocationsConfig.getDouble(path + ".pitch");
        return new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
    }

    public void loadAfkLocation() {
        if (this.plugin.getConfig().contains("afkLocation")) {
            String worldName = this.plugin.getConfig().getString("afkLocation.world");
            double x = this.plugin.getConfig().getDouble("afkLocation.x");
            double y = this.plugin.getConfig().getDouble("afkLocation.y");
            double z = this.plugin.getConfig().getDouble("afkLocation.z");
            this.afkLocation = new Location(Bukkit.getWorld((String)worldName), x, y, z);
        } else {
            this.afkLocation = null;
        }
    }

    public void removeAfkLocation() {
        this.afkLocation = null;
    }

    public void saveAfkLocation() {
        if (this.afkLocation != null) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.afkLocationFile);
            config.set("afkLocation.world", (Object)this.afkLocation.getWorld().getName());
            config.set("afkLocation.x", (Object)this.afkLocation.getX());
            config.set("afkLocation.y", (Object)this.afkLocation.getY());
            config.set("afkLocation.z", (Object)this.afkLocation.getZ());
            try {
                config.save(this.afkLocationFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not save AFK location: " + e.getMessage());
            }
        }
    }

    public void setAfkLocation(Player player) {
        this.afkLocation = player.getLocation();
        this.saveAfkLocationToConfig();
    }

    private void saveAfkLocationToConfig() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("afkLocation.world", (Object)this.afkLocation.getWorld().getName());
        config.set("afkLocation.x", (Object)this.afkLocation.getX());
        config.set("afkLocation.y", (Object)this.afkLocation.getY());
        config.set("afkLocation.z", (Object)this.afkLocation.getZ());
        this.plugin.saveConfig();
    }

    public void setAfk(Player player) {
        if (!this.afkData.containsKey(player.getUniqueId())) {
            this.savePlayerLocation(player);
            this.teleportToAfk(player);
            this.afkStartTime.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    public Location getAfkLocation() {
        return this.afkLocation;
    }

    public Location getLastLocation(Player player) {
        Location storedLocation = this.getStoredPlayerLocation(player);
        return storedLocation != null ? storedLocation : player.getLocation();
    }

    public boolean isAfk(Player player) {
        return this.afkData.containsKey(player.getUniqueId());
    }

    public void setLastLocation(Player player, Location location) {
        AfkData data = this.afkData.getOrDefault(player.getUniqueId(), new AfkData());
        data.setLastLocation(location);
        this.afkData.put(player.getUniqueId(), data);
        this.saveAfkData();
    }

    public void saveAfkData() {
        for (UUID uuid : this.afkData.keySet()) {
            AfkData data = this.afkData.get(uuid);
            this.afkDataConfig.set(uuid.toString() + ".lastLocation", (Object)data.getLastLocation());
        }
        try {
            this.afkDataConfig.save(this.afkDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save AFK data: " + e.getMessage());
        }
    }

    public void loadAfkData() {
        if (!this.afkDataFile.exists()) {
            this.plugin.saveResource("afkdata.yml", false);
        }
        this.afkDataConfig = YamlConfiguration.loadConfiguration((File)this.afkDataFile);
        for (String uuidStr : this.afkDataConfig.getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            Location lastLocation = (Location)this.afkDataConfig.get(uuidStr + ".lastLocation");
            this.afkData.put(uuid, new AfkData(lastLocation));
        }
    }

    public void removeAfkData(Player player) {
        this.afkData.remove(player.getUniqueId());
        this.afkStartTime.remove(player.getUniqueId());
        this.saveAfkData();
    }

    public void teleportToAfk(Player player) {
        if (this.afkLocation != null) {
            player.teleport(this.afkLocation);
            this.startAfkShardEarning(player);
        } else {
            player.sendMessage("AFK location is not set.");
        }
    }

    public void quitAfk(Player player) {
        Location lastLocation = this.getLastLocation(player);
        if (lastLocation != null) {
            player.teleport(lastLocation);
            this.removeAfkData(player);
            player.sendMessage("You have quit AFK mode.");
        } else {
            player.sendMessage("You were not in AFK mode.");
        }
    }

    private void startAfkShardEarning(final Player player) {
        final long afkEarnSeconds = this.plugin.getConfig().getLong("afkearnseconds", 30L);
        final int afkAmount = this.plugin.getConfig().getInt("afkamount", 1);
        new BukkitRunnable(){
            int countdown;
            {
                this.countdown = (int)afkEarnSeconds;
            }

            public void run() {
                if (AfkManager.this.isAfk(player)) {
                    player.sendTitle("", String.valueOf(ChatColor.LIGHT_PURPLE) + "EARN SHARDS IN " + this.countdown, 7, 12, 7);
                    if (this.countdown <= 0) {
                        AfkManager.this.plugin.getShardManager().addShards(player, afkAmount);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You earned " + afkAmount + " shard(s) while AFK!");
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                        this.countdown = (int)afkEarnSeconds;
                    } else {
                        --this.countdown;
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public boolean hasPlayerMoved(Player player, Location initialLocation) {
        Location currentLocation = player.getLocation();
        return initialLocation.getX() != currentLocation.getX() || initialLocation.getY() != currentLocation.getY() || initialLocation.getZ() != currentLocation.getZ();
    }

    public Xshards getPlugin() {
        return this.plugin;
    }
}

