/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.ShardData;
import com.xshards.ShopItem;
import com.xshards.Xshards;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ShardManager {
    private final Xshards plugin;
    private final Map<Player, ShardData> playerData;
    private final File playerDataFile;
    private final Map<Player, ShopItem> pendingPurchases;

    public ShardManager(Xshards plugin) {
        this.plugin = plugin;
        this.playerData = new HashMap<Player, ShardData>();
        this.playerDataFile = new File(plugin.getDataFolder(), "playerdata.yml");
        this.pendingPurchases = new HashMap<Player, ShopItem>();
        this.loadAllPlayerData();
    }

    public void addShards(Player player, int amount) {
        ShardData data = this.playerData.getOrDefault(player, new ShardData());
        data.addShards(amount);
        this.playerData.put(player, data);
        player.sendMessage("You earned " + amount + " shards!");
        this.savePlayerData(player);
    }

    public int getShards(Player player) {
        return this.playerData.getOrDefault(player, new ShardData()).getShards();
    }

    public void savePlayerData(Player player) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        String playerName = player.getName();
        config.set(playerName + ".shards", (Object)this.getShards(player));
        try {
            config.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save player data for " + playerName + "!", e);
        }
    }

    public void loadPlayerData(Player player) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        String playerName = player.getName();
        int shards = config.getInt(playerName + ".shards", 0);
        this.playerData.put(player, new ShardData(shards));
    }

    public void saveAllPlayerData() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        for (Map.Entry<Player, ShardData> entry : this.playerData.entrySet()) {
            String playerName = entry.getKey().getName();
            config.set(playerName + ".shards", (Object)entry.getValue().getShards());
        }
        try {
            config.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save player data!", e);
        }
    }

    public void loadAllPlayerData() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        for (String playerName : config.getKeys(false)) {
            int shards = config.getInt(playerName + ".shards", 0);
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) continue;
            this.playerData.put(player, new ShardData(shards));
        }
    }

    public void setPendingPurchase(Player player, ShopItem item) {
        this.pendingPurchases.put(player, item);
    }

    public ShopItem getPendingPurchase(Player player) {
        return this.pendingPurchases.get(player);
    }

    public void clearPendingPurchase(Player player) {
        this.pendingPurchases.remove(player);
    }
}

