/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.ShopItem;
import com.xshards.Xshards;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopManager {
    private final Xshards plugin;
    private final Map<Integer, ShopItem> shopItems;
    private final File shopDataFile;
    private FileConfiguration shopDataConfig;

    public ShopManager(Xshards plugin) {
        this.plugin = plugin;
        this.shopItems = new HashMap<Integer, ShopItem>();
        this.shopDataFile = new File(plugin.getDataFolder(), "shopdata.yml");
        this.loadShopData();
    }

    public void addItemToShop(int slot, ItemStack item, double price) {
        ItemStack shopItem = item.clone();
        ItemMeta meta = shopItem.getItemMeta();
        if (meta != null) {
            ArrayList<CallSite> lore;
            ArrayList<CallSite> arrayList = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            if (lore == null) {
                lore = new ArrayList<CallSite>();
            }
            lore.add((CallSite)((Object)("\u00a7ePrice: " + price + " Shards")));
            meta.setLore(lore);
            shopItem.setItemMeta(meta);
        }
        this.shopItems.put(slot, new ShopItem(item.clone(), price));
        this.saveShopData();
    }

    public void editItemPrice(int slot, double newPrice) {
        ShopItem existingItem = this.shopItems.get(slot);
        if (existingItem != null) {
            this.shopItems.put(slot, new ShopItem(existingItem.getItem(), newPrice));
            this.saveShopData();
        }
    }

    public void removeItemFromShop(int slot) {
        this.shopItems.remove(slot);
        this.shopDataConfig.set(String.valueOf(slot), null);
        this.saveShopData();
    }

    public ShopItem getItemInShop(int slot) {
        return this.shopItems.get(slot);
    }

    public void loadShopData() {
        if (!this.shopDataFile.exists()) {
            this.plugin.saveResource("shopdata.yml", false);
        }
        this.shopDataConfig = YamlConfiguration.loadConfiguration((File)this.shopDataFile);
        for (String key : this.shopDataConfig.getKeys(false)) {
            try {
                int slot = Integer.parseInt(key);
                ItemStack item = this.shopDataConfig.getItemStack(key + ".item");
                double price = this.shopDataConfig.getDouble(key + ".price");
                if (item == null) continue;
                this.shopItems.put(slot, new ShopItem(item, price));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void saveShopData() {
        this.shopDataConfig = new YamlConfiguration();
        for (Map.Entry<Integer, ShopItem> entry : this.shopItems.entrySet()) {
            this.shopDataConfig.set(String.valueOf(entry.getKey()) + ".item", (Object)entry.getValue().getItem());
            this.shopDataConfig.set(String.valueOf(entry.getKey()) + ".price", (Object)entry.getValue().getPrice());
        }
        try {
            this.shopDataConfig.save(this.shopDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save shop data: " + e.getMessage());
        }
    }

    public void openShopGUI(Player player) {
        int size = this.plugin.getConfig().getInt("store.size", 54);
        size = Math.min(54, Math.max(9, size / 9 * 9));
        Inventory shopInventory = Bukkit.createInventory(null, (int)size, (String)"Shard Shop");
        for (Map.Entry<Integer, ShopItem> entry : this.shopItems.entrySet()) {
            int slot = entry.getKey();
            if (slot >= size) continue;
            ShopItem shopItem = entry.getValue();
            ItemStack displayItem = shopItem.getItem().clone();
            ItemMeta meta = displayItem.getItemMeta();
            if (meta != null) {
                ArrayList<CallSite> lore;
                ArrayList<CallSite> arrayList = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                if (lore == null) {
                    lore = new ArrayList<CallSite>();
                }
                lore.add((CallSite)((Object)("\u00a7ePrice: " + shopItem.getPrice() + " Shards")));
                meta.setLore(lore);
                displayItem.setItemMeta(meta);
            }
            shopInventory.setItem(slot, displayItem);
        }
        player.openInventory(shopInventory);
    }
}

