/*
 * Decompiled with CFR 0.152.
 */
package com.xshards;

import com.xshards.AfkCommand;
import com.xshards.AfkListener;
import com.xshards.AfkManager;
import com.xshards.AfkRemoveCommand;
import com.xshards.QuitAfkCommand;
import com.xshards.SetAfkCommand;
import com.xshards.ShardCommand;
import com.xshards.ShardListener;
import com.xshards.ShardManager;
import com.xshards.ShopCommand;
import com.xshards.ShopListener;
import com.xshards.ShopManager;
import com.xshards.XshardsCommand;
import com.xshards.XshardsPlaceholder;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Xshards
extends JavaPlugin {
    private ShardManager shardManager;
    private ShopManager shopManager;
    private AfkManager afkManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.createDataFile("playerdata.yml");
        this.createDataFile("killsystem.yml");
        this.createDataFile("shopdata.yml");
        this.createDataFile("afkdata.yml");
        this.createDataFile("afkmod.yml");
        this.shardManager = new ShardManager(this);
        this.shopManager = new ShopManager(this);
        this.afkManager = new AfkManager(this);
        this.shopManager.loadShopData();
        this.afkManager.loadAfkData();
        this.afkManager.loadAfkLocation();
        this.shardManager.loadAllPlayerData();
        this.getCommand("shards").setExecutor((CommandExecutor)new ShardCommand(this.shardManager));
        this.getCommand("store").setExecutor((CommandExecutor)new ShopCommand(this.shopManager));
        this.getCommand("xshards").setExecutor((CommandExecutor)new XshardsCommand(this));
        this.getCommand("afk").setExecutor((CommandExecutor)new AfkCommand(this.afkManager));
        this.getCommand("setafk").setExecutor((CommandExecutor)new SetAfkCommand(this.afkManager));
        this.getCommand("quitafk").setExecutor((CommandExecutor)new QuitAfkCommand(this.afkManager));
        this.getCommand("afkremove").setExecutor((CommandExecutor)new AfkRemoveCommand(this.afkManager));
        this.getServer().getPluginManager().registerEvents((Listener)new ShardListener(this.shardManager, this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShopListener(this.shopManager, this.shardManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AfkListener(this.afkManager), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new XshardsPlaceholder(this.shardManager).register();
            this.getLogger().info("PlaceholderAPI detected. Shards placeholders registered!");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholders will not be available.");
        }
        File afkDataFile = new File(this.getDataFolder(), "afkdata.yml");
        if (afkDataFile.exists()) {
            afkDataFile.delete();
            this.saveResource("afkdata.yml", false);
        }
        this.getLogger().info("Xshards has been enabled!");
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.afkManager.isAfk(player)) continue;
            this.afkManager.quitAfk(player);
        }
        File afkDataFile = new File(this.getDataFolder(), "afkdata.yml");
        if (afkDataFile.exists()) {
            afkDataFile.delete();
        }
        this.shardManager.saveAllPlayerData();
        this.shopManager.saveShopData();
        this.getLogger().info("Xshards has been disabled.");
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.shopManager.loadShopData();
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public AfkManager getAfkManager() {
        return this.afkManager;
    }

    private void createDataFile(String filename) {
        File file = new File(this.getDataFolder(), filename);
        if (!file.exists()) {
            this.saveResource(filename, false);
        }
    }
}

