/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sEconomy.commands;

import dev.losterixx.sEconomy.Main;
import dev.losterixx.sEconomy.economy.EconomyManager;
import dev.losterixx.sEconomy.libs.YamlDocument;
import dev.losterixx.sEconomy.utils.ConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J5\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ;\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000e2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/losterixx/sEconomy/commands/EconomyCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "<init>", "()V", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "main", "Ldev/losterixx/sEconomy/Main;", "getConfig", "Ldev/losterixx/sEconomy/libs/YamlDocument;", "getMessages", "getPrefix", "", "eco", "Ldev/losterixx/sEconomy/economy/EconomyManager;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "S-Economy"})
@SourceDebugExtension(value={"SMAP\nEconomyCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EconomyCommand.kt\ndev/losterixx/sEconomy/commands/EconomyCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1563#2:188\n1634#2,3:189\n1869#2,2:192\n1869#2,2:194\n1869#2,2:196\n1869#2,2:198\n1869#2,2:200\n1869#2,2:202\n1563#2:204\n1634#2,3:205\n774#2:208\n865#2,2:209\n774#2:211\n865#2,2:212\n1563#2:214\n1634#2,3:215\n*S KotlinDebug\n*F\n+ 1 EconomyCommand.kt\ndev/losterixx/sEconomy/commands/EconomyCommand\n*L\n36#1:188\n36#1:189,3\n62#1:192,2\n87#1:194,2\n112#1:196,2\n131#1:198,2\n170#1:200,2\n174#1:202,2\n178#1:204\n178#1:205,3\n178#1:208\n178#1:209,2\n181#1:211\n181#1:212,2\n181#1:214\n181#1:215,3\n*E\n"})
public final class EconomyCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final MiniMessage mm = Main.Companion.getMiniMessage();
    @NotNull
    private final Main main = Main.Companion.getInstance();
    @NotNull
    private final EconomyManager eco = this.main.getEconomyManager();

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#ECC868><b>S-Economy</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label, @NotNull String[] args) {
        List targets;
        boolean isAll;
        block63: {
            block64: {
                Intrinsics.checkNotNullParameter(sender, "sender");
                Intrinsics.checkNotNullParameter(command2, "command");
                Intrinsics.checkNotNullParameter(label, "label");
                Intrinsics.checkNotNullParameter(args, "args");
                if (!(sender.hasPermission("sEconomy.command.eco.give") || sender.hasPermission("sEconomy.command.eco.take") || sender.hasPermission("sEconomy.command.eco.set") || sender.hasPermission("sEconomy.command.eco.reset") || sender.hasPermission("sEconomy.command.eco.check"))) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                    return false;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.usage"))));
                    return false;
                }
                isAll = Intrinsics.areEqual(args[1], "*");
                if (isAll) {
                    void $this$mapTo$iv$iv;
                    Collection collection = Bukkit.getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    Iterable $this$map$iv = collection;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Player player = (Player)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.bukkit.OfflinePlayer");
                        collection2.add((OfflinePlayer)it);
                    }
                    v1 = (List)destination$iv$iv;
                } else {
                    v1 = targets = CollectionsKt.listOf(Bukkit.getOfflinePlayer((String)args[1]));
                }
                if (isAll) break block63;
                if (!targets.get(0).hasPlayedBefore()) break block64;
                UUID uUID = targets.get(0).getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                if (this.eco.hasAccount(uUID)) break block63;
            }
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.playerNotFound"))));
            return false;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "add": 
            case "give": {
                String string2;
                OfflinePlayer it;
                if (!sender.hasPermission("sEconomy.command.eco.give")) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                    return false;
                }
                if (args.length != 3) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.give.usage"))));
                    return false;
                }
                Double amount = StringsKt.toDoubleOrNull(args[2]);
                if (amount == null || amount <= 0.0) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.noAmount"))));
                    return false;
                }
                Iterable $this$forEach$iv = targets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (OfflinePlayer)element$iv;
                    boolean bl = false;
                    this.eco.addBalance(it.getUniqueId(), amount);
                }
                String messageKey = isAll ? "commands.economy.give.all" : "commands.economy.give.success";
                String string3 = this.getPrefix();
                String string4 = this.getMessages().getString(messageKey);
                Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
                if (isAll) {
                    string2 = "*";
                } else {
                    string2 = ((OfflinePlayer)targets.get(0)).getName();
                    if (string2 == null) {
                        string2 = "?";
                    }
                }
                sender.sendMessage(this.mm.deserialize((Object)(string3 + StringsKt.replace$default(StringsKt.replace$default(string4, "%player%", string2, false, 4, null), "%balance%", this.eco.format(amount), false, 4, null))));
                break;
            }
            case "take": 
            case "remove": {
                String string5;
                OfflinePlayer it;
                if (!sender.hasPermission("sEconomy.command.eco.take")) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                    return false;
                }
                if (args.length != 3) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.take.usage"))));
                    return false;
                }
                Double amount = StringsKt.toDoubleOrNull(args[2]);
                if (amount == null || amount <= 0.0) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.noAmount"))));
                    return false;
                }
                Iterable $this$forEach$iv = targets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (OfflinePlayer)element$iv;
                    boolean bl = false;
                    this.eco.removeBalance(it.getUniqueId(), amount);
                }
                String messageKey = isAll ? "commands.economy.take.all" : "commands.economy.take.success";
                String string6 = this.getPrefix();
                String string7 = this.getMessages().getString(messageKey);
                Intrinsics.checkNotNullExpressionValue(string7, "getString(...)");
                if (isAll) {
                    string5 = "*";
                } else {
                    string5 = ((OfflinePlayer)targets.get(0)).getName();
                    if (string5 == null) {
                        string5 = "?";
                    }
                }
                sender.sendMessage(this.mm.deserialize((Object)(string6 + StringsKt.replace$default(StringsKt.replace$default(string7, "%player%", string5, false, 4, null), "%balance%", this.eco.format(amount), false, 4, null))));
                break;
            }
            case "set": {
                String string8;
                OfflinePlayer it;
                if (!sender.hasPermission("sEconomy.command.eco.set")) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                    return false;
                }
                if (args.length != 3) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.set.usage"))));
                    return false;
                }
                Double amount = StringsKt.toDoubleOrNull(args[2]);
                if (amount == null || amount < 0.0) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.noAmount"))));
                    return false;
                }
                Iterable $this$forEach$iv = targets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (OfflinePlayer)element$iv;
                    boolean bl = false;
                    this.eco.setBalance(it.getUniqueId(), amount);
                }
                String messageKey = isAll ? "commands.economy.set.all" : "commands.economy.set.success";
                String string9 = this.getPrefix();
                String string10 = this.getMessages().getString(messageKey);
                Intrinsics.checkNotNullExpressionValue(string10, "getString(...)");
                if (isAll) {
                    string8 = "*";
                } else {
                    string8 = ((OfflinePlayer)targets.get(0)).getName();
                    if (string8 == null) {
                        string8 = "?";
                    }
                }
                sender.sendMessage(this.mm.deserialize((Object)(string9 + StringsKt.replace$default(StringsKt.replace$default(string10, "%player%", string8, false, 4, null), "%balance%", this.eco.format(amount), false, 4, null))));
                break;
            }
            case "reset": {
                String string11;
                if (!sender.hasPermission("sEconomy.command.eco.reset")) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                    return false;
                }
                if (args.length != 2) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.reset.usage"))));
                    return false;
                }
                Iterable $this$forEach$iv = targets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    OfflinePlayer it = (OfflinePlayer)element$iv;
                    boolean bl = false;
                    this.eco.resetBalance(it.getUniqueId());
                }
                String messageKey = isAll ? "commands.economy.reset.all" : "commands.economy.reset.success";
                String string12 = this.getPrefix();
                String string13 = this.getMessages().getString(messageKey);
                Intrinsics.checkNotNullExpressionValue(string13, "getString(...)");
                if (isAll) {
                    string11 = "*";
                } else {
                    string11 = ((OfflinePlayer)targets.get(0)).getName();
                    if (string11 == null) {
                        string11 = "?";
                    }
                }
                sender.sendMessage(this.mm.deserialize((Object)(string12 + StringsKt.replace$default(string13, "%player%", string11, false, 4, null))));
                break;
            }
            case "check": {
                if (!sender.hasPermission("sEconomy.command.eco.check")) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                    return false;
                }
                if (args.length != 2) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.check.usage"))));
                    return false;
                }
                if (isAll) {
                    sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.check.allFailed"))));
                    return true;
                }
                String balance = this.eco.getFormattedBalance(((OfflinePlayer)targets.get(0)).getUniqueId());
                String string14 = this.getPrefix();
                String string15 = this.getMessages().getString("commands.economy.check.success");
                Intrinsics.checkNotNullExpressionValue(string15, "getString(...)");
                String string16 = ((OfflinePlayer)targets.get(0)).getName();
                if (string16 == null) {
                    string16 = "?";
                }
                sender.sendMessage(this.mm.deserialize((Object)(string14 + StringsKt.replace$default(StringsKt.replace$default(string15, "%player%", string16, false, 4, null), "%balance%", balance, false, 4, null))));
                break;
            }
            default: {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.economy.usage"))));
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        List completions = new ArrayList();
        if (args.length == 0) {
            String[] stringArray = new String[]{"give", "take", "set", "reset", "check"};
            Iterable $this$forEach$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!sender.hasPermission("sEconomy.command.eco." + it)) continue;
                completions.add(it);
            }
        } else if (args.length == 1) {
            Object $this$forEach$iv = new String[]{"give", "take", "set", "reset", "check"};
            $this$forEach$iv = CollectionsKt.listOf($this$forEach$iv);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                String it = (String)element$iv;
                boolean bl = false;
                if (!sender.hasPermission("sEconomy.command.eco." + it)) continue;
                String string = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                completions.add(it);
            }
        } else if (args.length == 2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Collection collection2 = CollectionsKt.listOf("*");
            Collection collection3 = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection3, "getOnlinePlayers(...)");
            Iterable $this$forEach$iv = collection3;
            Collection collection4 = collection2;
            List list = completions;
            boolean $i$f$map = false;
            void var8_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Player player = (Player)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = CollectionsKt.plus(collection4, (Iterable)collection);
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[1], true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        } else if (args.length == 3) {
            String[] $this$filter$iv = new String[]{"give", "take", "set"};
            List<String> list = CollectionsKt.listOf($this$filter$iv);
            String string = args[0].toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            if (list.contains(string)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Integer it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv2;
                Object $i$f$filter = new Integer[]{10, 50, 100};
                List<Integer> amounts = this.getConfig().getIntList("commands.economy.amountCompletions", CollectionsKt.listOf($i$f$filter));
                Intrinsics.checkNotNull(amounts);
                $i$f$filter = amounts;
                List list2 = completions;
                boolean $i$f$filter2 = false;
                void destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Integer)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default(it.toString(), args[2], false, 2, null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Integer)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                list2.addAll((List)destination$iv$iv2);
            }
        }
        return completions;
    }
}

