/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sEconomy.utils;

import dev.losterixx.sEconomy.Main;
import dev.losterixx.sEconomy.libs.YamlDocument;
import dev.losterixx.sEconomy.libs.settings.Settings;
import dev.losterixx.sEconomy.libs.settings.general.GeneralSettings;
import dev.losterixx.sEconomy.libs.settings.loader.LoaderSettings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0015J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/losterixx/sEconomy/utils/ConfigManager;", "", "<init>", "()V", "plugin", "Ldev/losterixx/sEconomy/Main;", "dataDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configs", "", "", "Ldev/losterixx/sEconomy/libs/YamlDocument;", "createConfig", "name", "resourcePath", "subDir", "existsConfig", "", "getConfig", "saveConfig", "", "reloadConfig", "saveAllConfigs", "reloadAllConfigs", "getAllConfigs", "", "S-Economy"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\ndev/losterixx/sEconomy/utils/ConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1869#2,2:105\n1869#2,2:107\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\ndev/losterixx/sEconomy/utils/ConfigManager\n*L\n83#1:105,2\n93#1:107,2\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static final Main plugin = Main.Companion.getInstance();
    private static final Path dataDirectory = plugin.getDataFolder().toPath();
    @NotNull
    private static final Map<String, YamlDocument> configs = new HashMap();

    private ConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final YamlDocument createConfig(@NotNull String name, @NotNull String resourcePath, @NotNull String subDir) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        Intrinsics.checkNotNullParameter(subDir, "subDir");
        Path configPath = ((CharSequence)subDir).length() > 0 ? dataDirectory.resolve(subDir).resolve(name + ".yml") : dataDirectory.resolve(name + ".yml");
        File configFile = configPath.toFile();
        try {
            if (!configFile.exists()) {
                InputStream inputStream = plugin.getResource(resourcePath);
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream2 = (InputStream)closeable;
                        boolean bl = false;
                        Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                        long l = Files.copy(inputStream2, configPath, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                } else {
                    throw new IOException("Resource not found: " + resourcePath);
                }
            }
            Settings[] settingsArray = new Settings[]{GeneralSettings.builder().build(), LoaderSettings.builder().build()};
            YamlDocument document = YamlDocument.create(configFile, settingsArray);
            configs.put(name, document);
            Intrinsics.checkNotNull(document);
            return document;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create config: " + name, e);
        }
    }

    public static /* synthetic */ YamlDocument createConfig$default(ConfigManager configManager, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return configManager.createConfig(string, string2, string3);
    }

    public final boolean existsConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return configs.containsKey(name);
    }

    @NotNull
    public final YamlDocument getConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        YamlDocument yamlDocument = configs.get(name);
        if (yamlDocument == null) {
            throw new NullPointerException("Config '" + name + ".yml' not found!");
        }
        return yamlDocument;
    }

    public final void saveConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        YamlDocument yamlDocument = configs.get(name);
        if (yamlDocument != null) {
            YamlDocument it = yamlDocument;
            boolean bl = false;
            try {
                boolean bl2 = it.save();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save config: " + name, e);
            }
        }
    }

    public final void reloadConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        YamlDocument yamlDocument = configs.get(name);
        if (yamlDocument != null) {
            YamlDocument it = yamlDocument;
            boolean bl = false;
            try {
                boolean bl2 = it.reload();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to reload config: " + name, e);
            }
        }
    }

    public final void saveAllConfigs() {
        Iterable $this$forEach$iv = configs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YamlDocument it = (YamlDocument)element$iv;
            boolean bl = false;
            try {
                it.save();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save all configs", e);
            }
        }
    }

    public final void reloadAllConfigs() {
        Iterable $this$forEach$iv = configs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YamlDocument it = (YamlDocument)element$iv;
            boolean bl = false;
            try {
                it.reload();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to reload all configs", e);
            }
        }
    }

    @NotNull
    public final Map<String, YamlDocument> getAllConfigs() {
        return configs;
    }

    static {
        try {
            if (!Files.exists(dataDirectory, new LinkOption[0])) {
                Files.createDirectories(dataDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create config directory: " + dataDirectory, e);
        }
    }
}

