/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sEconomy;

import dev.losterixx.sEconomy.economy.EconomyManager;
import dev.losterixx.sEconomy.economy.VaultHook;
import dev.losterixx.sEconomy.utils.ConfigManager;
import dev.losterixx.sEconomy.utils.ConfigUpdater;
import dev.losterixx.sEconomy.utils.CoroutineUtils;
import dev.losterixx.sEconomy.utils.RegisterManager;
import dev.losterixx.sEconomy.utils.UpdateChecker;
import dev.losterixx.sEconomy.utils.bStats.Metrics;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/losterixx/sEconomy/Main;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "value", "Ldev/losterixx/sEconomy/economy/EconomyManager;", "economyManager", "getEconomyManager", "()Ldev/losterixx/sEconomy/economy/EconomyManager;", "vaultHook", "Ldev/losterixx/sEconomy/economy/VaultHook;", "onEnable", "", "onDisable", "loadConfigFiles", "loadLangFiles", "isLatestVersion", "", "Companion", "S-Economy"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ndev/losterixx/sEconomy/Main\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1869#2,2:151\n*S KotlinDebug\n*F\n+ 1 Main.kt\ndev/losterixx/sEconomy/Main\n*L\n130#1:151,2\n*E\n"})
public final class Main
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private EconomyManager economyManager;
    private VaultHook vaultHook;
    private static Main instance;
    @NotNull
    public static final String DEFAULT_PREFIX = "<#ECC868><b>S-Economy</b> <dark_gray>\u26a1 <gray>";
    @NotNull
    private static final MiniMessage miniMessage;
    @Nullable
    private static LuckPerms luckperms;

    @NotNull
    public final EconomyManager getEconomyManager() {
        EconomyManager economyManager = this.economyManager;
        if (economyManager != null) {
            return economyManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("economyManager");
        return null;
    }

    public void onEnable() {
        LuckPerms luckPerms;
        VaultHook vaultHook;
        ServicesManager servicesManager;
        this.getLogger().info("Plugin is being enabled...");
        instance = this;
        this.loadLangFiles();
        this.loadConfigFiles();
        ConfigUpdater.INSTANCE.updateConfigs();
        this.getLogger().info("Loaded " + ConfigManager.INSTANCE.getAllConfigs().size() + " configs!");
        this.economyManager = new EconomyManager();
        this.vaultHook = new VaultHook();
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.getLogger().info("Vault found! Registering Vault economy hook...");
            servicesManager = this.getServer().getServicesManager();
            vaultHook = this.vaultHook;
            if (vaultHook == null) {
                Intrinsics.throwUninitializedPropertyAccessException("vaultHook");
                vaultHook = null;
            }
        } else {
            this.getLogger().warning("Vault not found! This plugin is required for the economy system to work.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        servicesManager.register(Economy.class, (Object)vaultHook, (Plugin)this, ServicePriority.High);
        this.getLogger().info("Vault economy hook registered!");
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") == null) {
            this.getLogger().warning("LuckPerms not found! The exempt permission for the /balancetop command will not work.");
            return;
        }
        luckperms = LuckPermsProvider.get();
        this.getLogger().info("Hooked into LuckPerms v" + ((luckPerms = luckperms) != null && (luckPerms = luckPerms.getPluginMetadata()) != null ? luckPerms.getVersion() : null) + "!");
        RegisterManager.INSTANCE.registerAll();
        if (ConfigManager.INSTANCE.getConfig("config").getBoolean("updateChecker.consoleMessage").booleanValue()) {
            CoroutineUtils.INSTANCE.launchAsync((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Main this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            if (!this.this$0.isLatestVersion()) {
                                this.this$0.getLogger().warning("You are not using the latest version of S-Economy! Please update to the latest version.");
                                this.this$0.getLogger().warning("Latest version: " + UpdateChecker.INSTANCE.getLatestGitHubRelease("Losterixx", "S-Economy"));
                                this.this$0.getLogger().warning("Your version: " + this.this$0.getDescription().getVersion());
                            } else {
                                this.this$0.getLogger().info("You are using the latest version of S-Economy!");
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
        Metrics metrics = new Metrics((Plugin)this, 25353);
        this.getLogger().info("Plugin has been enabled!");
    }

    public void onDisable() {
        CoroutineUtils.INSTANCE.cancelAll();
        this.getEconomyManager().saveBalances();
        this.getLogger().info("Plugin has been disabled!");
    }

    public final void loadConfigFiles() {
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "config", "config.yml", null, 4, null);
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "commands", "commands.yml", null, 4, null);
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "data", "data.yml", null, 4, null);
        this.loadLangFiles();
        String langFile = ConfigManager.INSTANCE.getConfig("config").getString("langFile", null);
        if (langFile == null) {
            this.getLogger().warning("No language file specified in config.yml! Defaulting to english.yml.");
            this.getConfig().set("langFile", (Object)"english");
            ConfigManager.INSTANCE.saveConfig("config");
        }
        Intrinsics.checkNotNull(langFile);
        ConfigManager.INSTANCE.createConfig(langFile, "lang/" + langFile + ".yml", "lang");
        this.getLogger().info("Using language file: " + langFile + ".yml");
    }

    public final void loadLangFiles() {
        Path langDirectory = this.getDataFolder().toPath().resolve("lang");
        if (!Files.exists(langDirectory, new LinkOption[0])) {
            Files.createDirectories(langDirectory, new FileAttribute[0]);
        }
        String[] stringArray = new String[]{"english.yml", "german.yml"};
        List<String> defaultLangFiles = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = defaultLangFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileName = (String)element$iv;
            boolean bl = false;
            String langConfig = StringsKt.removeSuffix(fileName, (CharSequence)".yml");
            ConfigManager.INSTANCE.createConfig(langConfig, "lang/" + fileName, "lang");
        }
        Files.list(langDirectory).filter(arg_0 -> Main.loadLangFiles$lambda$2(Main::loadLangFiles$lambda$1, arg_0)).forEach(arg_0 -> Main.loadLangFiles$lambda$4(Main::loadLangFiles$lambda$3, arg_0));
    }

    public final boolean isLatestVersion() {
        String string = this.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        String currentVersion = string;
        String latestVersion = UpdateChecker.INSTANCE.getLatestGitHubRelease("Losterixx", "S-Economy");
        return latestVersion != null && Intrinsics.areEqual(latestVersion, currentVersion);
    }

    private static final boolean loadLangFiles$lambda$1(Path it) {
        return StringsKt.endsWith$default(((Object)it).toString(), ".yml", false, 2, null);
    }

    private static final boolean loadLangFiles$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit loadLangFiles$lambda$3(Path langFile) {
        String langConfig = StringsKt.removeSuffix(((Object)langFile.getFileName()).toString(), (CharSequence)".yml");
        if (!ConfigManager.INSTANCE.existsConfig(langConfig)) {
            ConfigManager.INSTANCE.createConfig(langConfig, "lang/" + langFile.getFileName(), "lang");
        }
        return Unit.INSTANCE;
    }

    private static final void loadLangFiles$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
        Main.miniMessage = miniMessage;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/losterixx/sEconomy/Main$Companion;", "", "<init>", "()V", "value", "Ldev/losterixx/sEconomy/Main;", "instance", "getInstance", "()Ldev/losterixx/sEconomy/Main;", "DEFAULT_PREFIX", "", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "getMiniMessage", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lnet/luckperms/api/LuckPerms;", "luckperms", "getLuckperms", "()Lnet/luckperms/api/LuckPerms;", "S-Economy"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Main getInstance() {
            Main main = instance;
            if (main != null) {
                return main;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @NotNull
        public final MiniMessage getMiniMessage() {
            return miniMessage;
        }

        @Nullable
        public final LuckPerms getLuckperms() {
            return luckperms;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

