/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sEconomy.commands;

import dev.losterixx.sEconomy.Main;
import dev.losterixx.sEconomy.economy.EconomyManager;
import dev.losterixx.sEconomy.libs.YamlDocument;
import dev.losterixx.sEconomy.utils.ConfigManager;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J5\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/losterixx/sEconomy/commands/BalanceTopCommand;", "Lorg/bukkit/command/CommandExecutor;", "<init>", "()V", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "main", "Ldev/losterixx/sEconomy/Main;", "getConfig", "Ldev/losterixx/sEconomy/libs/YamlDocument;", "getMessages", "getPrefix", "", "eco", "Ldev/losterixx/sEconomy/economy/EconomyManager;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "S-Economy"})
public final class BalanceTopCommand
implements CommandExecutor {
    @NotNull
    private final MiniMessage mm = Main.Companion.getMiniMessage();
    @NotNull
    private final Main main = Main.Companion.getInstance();
    @NotNull
    private final EconomyManager eco = this.main.getEconomyManager();

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#ECC868><b>S-Economy</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("sEconomy.command.balancetop")) {
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
            return false;
        }
        if (!(args.length == 0)) {
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.balancetop.usage"))));
            return false;
        }
        List<Pair<UUID, Double>> topAccounts = this.eco.getTopAccounts(10, true);
        if (topAccounts.isEmpty()) {
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.balancetop.noPlayers"))));
            return false;
        }
        sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.balancetop.header"))));
        Iterator iterator2 = ((Iterable)topAccounts).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Pair entry = (Pair)iterator2.next();
            UUID uuid = (UUID)entry.getFirst();
            double balance = ((Number)entry.getSecond()).doubleValue();
            String string = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            if (string == null) {
                string = "???";
            }
            String name = string;
            String formattedBalance = this.eco.format(balance);
            String string2 = this.getMessages().getString("commands.balancetop.entry");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            sender.sendMessage(this.mm.deserialize((Object)StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string2, "%index%", String.valueOf(index + 1), false, 4, null), "%name%", name, false, 4, null), "%balance%", formattedBalance, false, 4, null)));
        }
        return true;
    }
}

