/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sEconomy.commands;

import dev.losterixx.sEconomy.Main;
import dev.losterixx.sEconomy.economy.EconomyManager;
import dev.losterixx.sEconomy.libs.YamlDocument;
import dev.losterixx.sEconomy.utils.ConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J5\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ;\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000e2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/losterixx/sEconomy/commands/PayCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "<init>", "()V", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "main", "Ldev/losterixx/sEconomy/Main;", "getConfig", "Ldev/losterixx/sEconomy/libs/YamlDocument;", "getMessages", "getPrefix", "", "eco", "Ldev/losterixx/sEconomy/economy/EconomyManager;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "S-Economy"})
@SourceDebugExtension(value={"SMAP\nPayCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PayCommand.kt\ndev/losterixx/sEconomy/commands/PayCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1563#2:119\n1634#2,3:120\n1563#2:123\n1634#2,3:124\n774#2:127\n865#2,2:128\n774#2:130\n865#2,2:131\n1563#2:133\n1634#2,3:134\n*S KotlinDebug\n*F\n+ 1 PayCommand.kt\ndev/losterixx/sEconomy/commands/PayCommand\n*L\n105#1:119\n105#1:120,3\n108#1:123\n108#1:124,3\n108#1:127\n108#1:128,2\n112#1:130\n112#1:131,2\n112#1:133\n112#1:134,3\n*E\n"})
public final class PayCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final MiniMessage mm = Main.Companion.getMiniMessage();
    @NotNull
    private final Main main = Main.Companion.getInstance();
    @NotNull
    private final EconomyManager eco = this.main.getEconomyManager();

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#ECC868><b>S-Economy</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("sEconomy.command.pay") && !sender.hasPermission("sEconomy.command.pay.all")) {
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.pay.usage"))));
            return false;
        }
        Player player = (Player)sender;
        Double amount = StringsKt.toDoubleOrNull(args[1]);
        if (amount == null || amount < this.getConfig().getDouble("command.pay.minAmount", (Double)0.0)) {
            sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.pay.noAmount"))));
            return false;
        }
        if (StringsKt.equals(args[0], "*", true)) {
            if (!sender.hasPermission("sEconomy.command.pay.all")) {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                return false;
            }
            if (amount * (double)Bukkit.getOnlinePlayers().size() - 1.0 > this.eco.getBalance(player.getUniqueId())) {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.pay.notEnoughMoney"))));
                return false;
            }
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (Intrinsics.areEqual(target, sender)) continue;
                this.eco.pay(player.getUniqueId(), target.getUniqueId(), amount);
                String string = this.getPrefix();
                String string2 = this.getMessages().getString("commands.pay.success.target");
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                String string3 = ((Player)sender).getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                target.sendMessage(this.mm.deserialize((Object)(string + StringsKt.replace$default(StringsKt.replace$default(string2, "%player%", string3, false, 4, null), "%balance%", this.eco.format(amount), false, 4, null))));
            }
            String string = this.getPrefix();
            String string4 = this.getMessages().getString("commands.pay.success.all");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            sender.sendMessage(this.mm.deserialize((Object)(string + StringsKt.replace$default(string4, "%balance%", this.eco.format(amount), false, 4, null))));
        } else {
            if (!sender.hasPermission("sEconomy.command.pay")) {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.noPerms"))));
                return false;
            }
            if (amount > this.eco.getBalance(player.getUniqueId())) {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.pay.notEnoughMoney"))));
                return false;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("general.playerNotFound"))));
                return false;
            }
            if (Intrinsics.areEqual(target, sender)) {
                sender.sendMessage(this.mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.pay.selfPay"))));
                return false;
            }
            this.eco.pay(player.getUniqueId(), target.getUniqueId(), amount);
            String string = this.getPrefix();
            String string5 = this.getMessages().getString("commands.pay.success.player");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            String string6 = target.getName();
            Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
            sender.sendMessage(this.mm.deserialize((Object)(string + StringsKt.replace$default(StringsKt.replace$default(string5, "%player%", string6, false, 4, null), "%balance%", this.eco.format(amount), false, 4, null))));
            String string7 = this.getPrefix();
            String string8 = this.getMessages().getString("commands.pay.success.target");
            Intrinsics.checkNotNullExpressionValue(string8, "getString(...)");
            String string9 = player.getName();
            Intrinsics.checkNotNullExpressionValue(string9, "getName(...)");
            target.sendMessage(this.mm.deserialize((Object)(string7 + StringsKt.replace$default(StringsKt.replace$default(string8, "%player%", string9, false, 4, null), "%balance%", this.eco.format(amount), false, 4, null))));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        List completions = new ArrayList();
        if (!sender.hasPermission("sEconomy.command.pay") && !sender.hasPermission("sEconomy.command.pay.all")) {
            return completions;
        }
        if (args.length == 0) {
            if (sender.hasPermission("sEconomy.command.pay")) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable iterable = collection;
                List list = completions;
                boolean $i$f$map = false;
                void var8_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player player = (Player)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    collection2.add(string);
                }
                list.addAll((List)destination$iv$iv);
            }
            if (sender.hasPermission("sEconomy.command.pay.all")) {
                completions.add("*");
            }
        } else if (args.length == 1) {
            if (sender.hasPermission("sEconomy.command.pay")) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object it;
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable $this$map$iv = collection;
                List list = completions;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Player)item$iv$iv;
                    Collection collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(it.getName());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    if (!StringsKt.startsWith((String)it, args[0], true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list.addAll((List)destination$iv$iv);
            }
            if (sender.hasPermission("sEconomy.command.pay.all")) {
                String string = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (StringsKt.startsWith$default("*", string, false, 2, null)) {
                    completions.add("*");
                }
            }
        } else if (args.length == 2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Integer it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object $i$f$filter = new Integer[]{10, 50, 100};
            List<Integer> amounts = this.getConfig().getIntList("commands.pay.amountCompletions", CollectionsKt.listOf($i$f$filter));
            Intrinsics.checkNotNull(amounts);
            $i$f$filter = amounts;
            List list = completions;
            boolean $i$f$filter2 = false;
            void destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Integer)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it.toString(), args[1], false, 2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.toString());
            }
            list.addAll((List)destination$iv$iv2);
        }
        return completions;
    }
}

