/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sEconomy.economy;

import dev.losterixx.sEconomy.libs.YamlDocument;
import dev.losterixx.sEconomy.utils.ConfigManager;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0016\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0017\u001a\u00020\u00182\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\bJ\"\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010$\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\u0013R\u0011\u0010\u001e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Ldev/losterixx/sEconomy/economy/EconomyManager;", "", "<init>", "()V", "getConfig", "Ldev/losterixx/sEconomy/libs/YamlDocument;", "getData", "getBalance", "", "uuid", "Ljava/util/UUID;", "getFormattedBalance", "", "getTopAccounts", "", "Lkotlin/Pair;", "limit", "", "setBalance", "", "amount", "addBalance", "removeBalance", "hasEnough", "", "pay", "from", "to", "hasAccount", "resetBalance", "currencySymbol", "getCurrencySymbol", "()Ljava/lang/String;", "factorialDigits", "getFactorialDigits", "()I", "format", "saveBalances", "S-Economy"})
@SourceDebugExtension(value={"SMAP\nEconomyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EconomyManager.kt\ndev/losterixx/sEconomy/economy/EconomyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1068#2:94\n*S KotlinDebug\n*F\n+ 1 EconomyManager.kt\ndev/losterixx/sEconomy/economy/EconomyManager\n*L\n34#1:94\n*E\n"})
public final class EconomyManager {
    @NotNull
    private final String currencySymbol;
    private final int factorialDigits;

    public EconomyManager() {
        String string = this.getConfig().getString("economy.currencySymbol", "$");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        this.currencySymbol = string;
        Integer n = this.getConfig().getInt("economy.fractionalDigits", (Integer)2);
        Intrinsics.checkNotNullExpressionValue(n, "getInt(...)");
        this.factorialDigits = ((Number)n).intValue();
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getData() {
        return ConfigManager.INSTANCE.getConfig("data");
    }

    public final double getBalance(@Nullable UUID uuid) {
        Double d = this.getData().getDouble(uuid + ".balance", (Double)-1.0);
        Intrinsics.checkNotNullExpressionValue(d, "getDouble(...)");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final String getFormattedBalance(@Nullable UUID uuid) {
        Double d = this.getData().getDouble(uuid + ".balance", (Double)-1.0);
        Intrinsics.checkNotNullExpressionValue(d, "getDouble(...)");
        return this.format(((Number)d).doubleValue());
    }

    @NotNull
    public final List<Pair<UUID, Double>> getTopAccounts(int limit) {
        List accounts = new ArrayList();
        for (String key : this.getData().getRoutesAsStrings(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                double balance = this.getBalance(uuid);
                if (!(balance >= 0.0)) continue;
                accounts.add(TuplesKt.to(uuid, balance));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Iterable $this$sortedByDescending$iv = accounts;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take(CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getSecond()));
            }
        }), limit);
    }

    public final void setBalance(@Nullable UUID uuid, double amount) {
        this.getData().set(uuid + ".balance", (Object)amount);
        ConfigManager.INSTANCE.saveConfig("data");
    }

    public final void addBalance(@Nullable UUID uuid, double amount) {
        this.setBalance(uuid, this.getBalance(uuid) + amount);
    }

    public final void removeBalance(@Nullable UUID uuid, double amount) {
        this.setBalance(uuid, this.getBalance(uuid) - amount);
    }

    public final boolean hasEnough(@Nullable UUID uuid, double amount) {
        return this.getBalance(uuid) >= amount;
    }

    public final void pay(@Nullable UUID from, @Nullable UUID to, double amount) throws IllegalStateException {
        if (!this.hasEnough(from, amount)) {
            throw new IllegalStateException("Sender does not have enough balance.");
        }
        this.removeBalance(from, amount);
        this.addBalance(to, amount);
    }

    public final boolean hasAccount(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.getData().contains(uuid.toString());
    }

    public final void resetBalance(@Nullable UUID uuid) {
        Double d = this.getConfig().getDouble("economy.startingBalance", (Double)0.0);
        Intrinsics.checkNotNullExpressionValue(d, "getDouble(...)");
        this.setBalance(uuid, ((Number)d).doubleValue());
    }

    @NotNull
    public final String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public final int getFactorialDigits() {
        return this.factorialDigits;
    }

    @NotNull
    public final String format(double amount) {
        String decimalFormatPattern = this.getConfig().getString("economy.decimalFormat.format", "#,###.##");
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(Locale.of(this.getConfig().getString("economy.decimalFormat.locale", "ENGLISH")));
        DecimalFormat decimalFormat = new DecimalFormat(decimalFormatPattern, decimalSymbols);
        String formattedAmount = decimalFormat.format(amount);
        String string = this.getConfig().getString("economy.format", "%currencySymbol%%amount%");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = StringsKt.replace$default(string, "%currencySymbol%", this.currencySymbol, false, 4, null);
        Intrinsics.checkNotNull(formattedAmount);
        String format = StringsKt.replace$default(string2, "%amount%", formattedAmount, false, 4, null);
        return format;
    }

    public final void saveBalances() {
        ConfigManager.INSTANCE.saveConfig("data");
    }
}

