/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.heartless.dimensions.ModDimensions;
import net.heartless.heartless_arsonal.block.ModBlocks;
import net.heartless.heartless_arsonal.effect.ModEffects;
import net.heartless.heartless_arsonal.entity.ModEntities;
import net.heartless.heartless_arsonal.entity.custom.BloodBathBlotEntity;
import net.heartless.heartless_arsonal.item.ModItemGroups;
import net.heartless.heartless_arsonal.item.ModItems;
import net.heartless.heartless_arsonal.item.custom.BloodMeter;
import net.heartless.heartless_arsonal.item.custom.DimensionRespawning;
import net.heartless.heartless_arsonal.item.custom.DimensionalRiftItem;
import net.heartless.heartless_arsonal.item.custom.HeartlessCookieDIEDLMAO;
import net.heartless.heartless_arsonal.item.custom.ModCommands;
import net.heartless.heartless_arsonal.potion.ModPotions;
import net.heartless.heartless_arsonal.sound.ModSounds;
import net.heartless.heartless_arsonal.util.HammerUsageEvent;
import net.heartless.heartless_arsonal.util.ModLootTables;
import net.heartless.heartless_arsonal.world.gen.ModWorldGeneration;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartlessArsonal
implements ModInitializer {
    public static final String MOD_ID = "heartless_arsonal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"heartless_arsonal");

    public void onInitialize() {
        HeartlessCookieDIEDLMAO.init();
        ModSounds.registerSounds();
        ModEntities.registerModEntities();
        ModBlocks.registerModBlocks();
        ModItems.registerModItems();
        ModItemGroups.registerItemGroups();
        ModEffects.registerEffects();
        ModPotions.registerPotions();
        ModDimensions.register();
        ModLootTables.modifyLootTables();
        DimensionRespawning.register();
        ModWorldGeneration.generateModWorldGen();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 patt0$temp = handler.field_14140;
            if (patt0$temp instanceof class_3222) {
                class_3222 serverPlayer = patt0$temp;
                BloodMeter.initializePlayer(serverPlayer);
                LOGGER.info("Blood Meter initialized for player: {}", (Object)serverPlayer.method_5477().getString());
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 patt0$temp = handler.field_14140;
            if (patt0$temp instanceof class_3222) {
                class_3222 serverPlayer = patt0$temp;
                BloodMeter.removePlayer(serverPlayer);
                LOGGER.info("Blood Meter removed for player: {}", (Object)serverPlayer.method_5477().getString());
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((Object)new HammerUsageEvent());
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            DimensionalRiftItem.tick(server);
            for (class_3222 player : server.method_3760().method_14571()) {
                BloodMeter.tickPlayer(player);
            }
        });
        CommandRegistrationCallback.EVENT.register(DimensionalRiftItem::registerCommand);
        CommandRegistrationCallback.EVENT.register(ModCommands::register);
        System.out.println("Dimensional Rift Event Initialized!");
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> builder.method_59705(class_1847.field_8999, class_1802.field_8426, ModPotions.FROST_POTION));
        FabricDefaultAttributeRegistry.register(ModEntities.BLOOD_BATH_BLOT, (class_5132.class_5133)BloodBathBlotEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.ANGEL_PROJECTILE, (class_5132.class_5133)BloodBathBlotEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.ANGEL_SCYTHE_SWEEP, (class_5132.class_5133)BloodBathBlotEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BLOOD_BATH_SWEEP, (class_5132.class_5133)BloodBathBlotEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BLOOD_BATH_GUARD, (class_5132.class_5133)BloodBathBlotEntity.createAttributes());
        LOGGER.info("When the Only way to win is give in");
    }
}

