/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal.item.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.heartless.heartless_arsonal.item.ModItems;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class BloodMeter {
    private static final Map<UUID, Float> PLAYER_BLOOD = new HashMap<UUID, Float>();
    public static final float MAX_BLOOD = 100.0f;
    public static final float DAMAGE_TO_BLOOD_MULTIPLIER = 5.0f;
    public static final float BLOOD_GAIN_PER_HIT = 5.0f;
    public static final float BLOOD_GAIN_FROM_FLASK = 20.0f;
    public static final float BLOOD_COST_FOR_SCYTHE = 50.0f;
    private static final int DEPLETION_EFFECT_DURATION_TICKS = 200;

    public static void initializePlayer(class_3222 player) {
        if (!PLAYER_BLOOD.containsKey(player.method_5667())) {
            PLAYER_BLOOD.put(player.method_5667(), Float.valueOf(100.0f));
        }
    }

    public static void removePlayer(class_3222 player) {
        PLAYER_BLOOD.remove(player.method_5667());
    }

    public static boolean isFullArmorSetEquipped(class_1657 player) {
        boolean hasHelmet = player.method_6118(class_1304.field_6169).method_31574(ModItems.BLOOD_BATH_CRYSTAL_HELMET);
        boolean hasChestplate = player.method_6118(class_1304.field_6174).method_31574(ModItems.BLOOD_BATH_CRYSTAL_CHESTPLATE);
        boolean hasLeggings = player.method_6118(class_1304.field_6172).method_31574(ModItems.BLOOD_BATH_CRYSTAL_LEGGINGS);
        boolean hasBoots = player.method_6118(class_1304.field_6166).method_31574(ModItems.BLOOD_BATH_CRYSTAL_BOOTS);
        return hasHelmet && hasChestplate && hasLeggings && hasBoots;
    }

    public static void tickPlayer(class_3222 player) {
        if (BloodMeter.isFullArmorSetEquipped((class_1657)player)) {
            BloodMeter.updateActionBar(player);
        }
    }

    public static float getCurrentBlood(UUID playerUuid) {
        return PLAYER_BLOOD.getOrDefault(playerUuid, Float.valueOf(0.0f)).floatValue();
    }

    public static void takeDamage(class_3222 player, float damageAmount) {
        float bloodLoss = damageAmount * 5.0f;
        Float currentBlood = PLAYER_BLOOD.getOrDefault(player.method_5667(), Float.valueOf(100.0f));
        currentBlood = Float.valueOf(currentBlood.floatValue() - bloodLoss);
        currentBlood = Float.valueOf(Math.max(0.0f, currentBlood.floatValue()));
        PLAYER_BLOOD.put(player.method_5667(), currentBlood);
        BloodMeter.updateActionBar(player);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11209, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 10, 0.3, 0.5, 0.3, 0.1);
        if (currentBlood.floatValue() <= 0.0f) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Your Blood Meter has been depleted! You are now vulnerable and taking damage.").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), false);
            player.method_6092(new class_1293(class_1294.field_38092, 200, 1, true, false));
            player.method_6092(new class_1293(class_1294.field_5916, 200, 0, true, false));
        }
    }

    public static void gainBloodFromAttack(class_3222 player) {
        if (!BloodMeter.isFullArmorSetEquipped((class_1657)player)) {
            return;
        }
        Float currentBlood = PLAYER_BLOOD.getOrDefault(player.method_5667(), Float.valueOf(0.0f));
        currentBlood = Float.valueOf(currentBlood.floatValue() + 5.0f);
        currentBlood = Float.valueOf(Math.min(100.0f, currentBlood.floatValue()));
        PLAYER_BLOOD.put(player.method_5667(), currentBlood);
        BloodMeter.updateActionBar(player);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11211, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 5, 0.3, 0.5, 0.3, 0.1);
    }

    public static void addBloodFromFlask(class_3222 player) {
        Float currentBlood = PLAYER_BLOOD.getOrDefault(player.method_5667(), Float.valueOf(0.0f));
        currentBlood = Float.valueOf(currentBlood.floatValue() + 20.0f);
        currentBlood = Float.valueOf(Math.min(100.0f, currentBlood.floatValue()));
        PLAYER_BLOOD.put(player.method_5667(), currentBlood);
        BloodMeter.updateActionBar(player);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11213, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 15, 0.5, 0.5, 0.5, 0.1);
        player.method_7353((class_2561)class_2561.method_43470((String)"\ud83e\ude78 Blood: +20.0!").method_27692(class_124.field_1060), true);
    }

    public static boolean useBloodForAbility(class_3222 player, float amount) {
        Float currentBlood = PLAYER_BLOOD.getOrDefault(player.method_5667(), Float.valueOf(0.0f));
        if (currentBlood.floatValue() >= amount) {
            currentBlood = Float.valueOf(currentBlood.floatValue() - amount);
            PLAYER_BLOOD.put(player.method_5667(), currentBlood);
            BloodMeter.updateActionBar(player);
            ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11205, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 5, 0.3, 0.5, 0.3, 0.1);
            return true;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("Not enough blood! Required: " + amount + " Current: " + String.format("%.1f", currentBlood))).method_27692(class_124.field_1079), true);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11251, player.method_23317(), player.method_23318() + (double)player.method_17682() / 2.0, player.method_23321(), 5, 0.3, 0.5, 0.3, 0.01);
        return false;
    }

    private static void updateActionBar(class_3222 player) {
        if (!BloodMeter.isFullArmorSetEquipped((class_1657)player)) {
            return;
        }
        Float currentBlood = PLAYER_BLOOD.getOrDefault(player.method_5667(), Float.valueOf(100.0f));
        class_5250 actionBarText = class_2561.method_43470((String)"\ud83e\ude78 Blood: ").method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f", currentBlood)).method_27695(new class_124[]{currentBlood.floatValue() > 25.0f ? class_124.field_1061 : class_124.field_1079, class_124.field_1067}));
        player.method_7353((class_2561)actionBarText, true);
    }
}

