/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal.item.custom;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Random;
import net.heartless.heartless_arsonal.item.ModItems;
import net.heartless.heartless_arsonal.sound.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1593;
import net.minecraft.class_1634;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class DimensionalRiftItem {
    private static final int MIN_DELAY_TICKS = 24000;
    private static final int MAX_DELAY_TICKS = 54000;
    private static final int DROP_DELAY_TICKS = 6000;
    private static final int SPOOKY_SOUND_START_TICKS = 2400;
    private static final int CHAOS_START_TICKS = 1200;
    private static final float RIFT_CORE_RADIUS = 0.5f;
    private static final float RIFT_EDGE_RADIUS = 10.0f;
    private static final float RIFT_SKY_SWIRL_RADIUS = 15.0f;
    private static final int RIFT_SKY_SWIRL_HEIGHT = 20;
    private static final int MOB_SPAWN_INTERVAL_TICKS = 100;
    private static final List<class_1799> RIFT_REWARD_ITEMS = List.of(new class_1799((class_1935)class_1802.field_8463, 5), new class_1799((class_1935)ModItems.BLOOD_BATH_INGOT, 16), new class_1799((class_1935)ModItems.GUILT_ENGINE_CORE, 1), new class_1799((class_1935)ModItems.ARAGONITE_CRYSTAL, 6), new class_1799((class_1935)class_1802.field_8634, 16), new class_1799((class_1935)class_1802.field_28354, 1), new class_1799((class_1935)class_1802.field_8477, 8), new class_1799((class_1935)ModItems.HEART_TECH_SMITHING_TEMPLATE, 2));
    private static final int MAX_RADIUS = 2500;
    private static final int MIN_Y_LEVEL = 60;
    private static int ticksUntilNextRift = 12000;
    private static Rift activeRift = null;
    private static final Random RANDOM = new Random();

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"startrift").requires(source -> source.method_9259(2))).executes(context -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            if (activeRift != null) {
                int secondsLeft = DimensionalRiftItem.activeRift.dropTimer / 20;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("A Dimensional Rift is already active! Item drops in " + secondsLeft + " seconds.")), false);
                return 0;
            }
            DimensionalRiftItem.startNewRift(server);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Manually starting a new Dimensional Rift event."), true);
            ticksUntilNextRift = RANDOM.nextInt(30000) + 24000;
            return 1;
        });
        dispatcher.register(command);
    }

    public static void tick(MinecraftServer server) {
        if (server.method_54833().method_54754()) {
            return;
        }
        if (activeRift != null) {
            int minutesLeft;
            --DimensionalRiftItem.activeRift.dropTimer;
            class_3218 world = server.method_3847(DimensionalRiftItem.activeRift.dimension);
            if (world != null) {
                int lightningInterval;
                boolean isChaos = DimensionalRiftItem.activeRift.dropTimer < 1200;
                float ambientVolume = isChaos ? 0.5f : 0.25f;
                world.method_43128(null, (double)DimensionalRiftItem.activeRift.position.method_10263() + 0.5, (double)DimensionalRiftItem.activeRift.position.method_10264() + 1.0, (double)DimensionalRiftItem.activeRift.position.method_10260() + 0.5, class_3417.field_14802, class_3419.field_15254, ambientVolume, RANDOM.nextFloat() * 0.4f + 0.8f);
                int n = lightningInterval = isChaos ? 20 : 60;
                if (DimensionalRiftItem.activeRift.dropTimer > 0 && DimensionalRiftItem.activeRift.dropTimer % lightningInterval == 0) {
                    class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
                    double lightningX = (double)DimensionalRiftItem.activeRift.position.method_10263() + 0.5 + (RANDOM.nextDouble() - 0.5) * 5.0;
                    double lightningZ = (double)DimensionalRiftItem.activeRift.position.method_10260() + 0.5 + (RANDOM.nextDouble() - 0.5) * 5.0;
                    double lightningY = DimensionalRiftItem.activeRift.position.method_10264();
                    lightning.method_23327(lightningX, lightningY, lightningZ);
                    lightning.method_29498(true);
                    world.method_8649((class_1297)lightning);
                    world.method_43128(null, (double)DimensionalRiftItem.activeRift.position.method_10263() + 0.5, (double)DimensionalRiftItem.activeRift.position.method_10264() + 1.0, (double)DimensionalRiftItem.activeRift.position.method_10260() + 0.5, class_3417.field_14865, class_3419.field_15252, 2.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
                }
                if (DimensionalRiftItem.activeRift.dropTimer < 2400) {
                    int spookyInterval;
                    int n2 = spookyInterval = isChaos ? 50 : 200;
                    if (DimensionalRiftItem.activeRift.dropTimer % spookyInterval == 0) {
                        world.method_43128(null, (double)DimensionalRiftItem.activeRift.position.method_10263() + 0.5, (double)DimensionalRiftItem.activeRift.position.method_10264() + 1.0, (double)DimensionalRiftItem.activeRift.position.method_10260() + 0.5, ModSounds.ANGEL_CHARGE, class_3419.field_15256, 1.0f, RANDOM.nextFloat() * 0.2f + 0.9f);
                    }
                }
                if (isChaos && DimensionalRiftItem.activeRift.dropTimer > 0 && DimensionalRiftItem.activeRift.dropTimer % 100 == 0) {
                    DimensionalRiftItem.spawnRiftGuardians(world, DimensionalRiftItem.activeRift.position);
                }
            }
            if (DimensionalRiftItem.activeRift.dropTimer % 1 == 0) {
                DimensionalRiftItem.spawnRiftParticles(server, activeRift);
            }
            if (DimensionalRiftItem.activeRift.dropTimer % 1200 == 0 && DimensionalRiftItem.activeRift.dropTimer > 0 && (minutesLeft = DimensionalRiftItem.activeRift.dropTimer / 1200) > 0) {
                class_5250 updateMessage = class_2561.method_43470((String)"[Heartless Industries] ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"The shift at ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)String.format("X: %d, Z: %d", DimensionalRiftItem.activeRift.position.method_10263(), DimensionalRiftItem.activeRift.position.method_10260())).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(" will drop its artifact in approximately " + minutesLeft + " minutes.")).method_27692(class_124.field_1054));
                server.method_3760().method_43514((class_2561)updateMessage, false);
            }
            if (DimensionalRiftItem.activeRift.dropTimer <= 0) {
                DimensionalRiftItem.dropItemAtRift(server, activeRift);
                activeRift = null;
            }
            return;
        }
        if (--ticksUntilNextRift <= 0) {
            DimensionalRiftItem.startNewRift(server);
            ticksUntilNextRift = RANDOM.nextInt(30000) + 24000;
        }
    }

    public static void startNewRift(MinecraftServer server) {
        class_3218 world = server.method_3847(class_1937.field_25179);
        if (world == null) {
            System.err.println("Could not find the Overworld to start rift event.");
            return;
        }
        class_2338 riftPos = DimensionalRiftItem.findRandomSurfacePos(world);
        activeRift = new Rift(riftPos, (class_5321<class_1937>)class_1937.field_25179);
        DimensionalRiftItem.announceRift(server, riftPos);
        world.method_43128(null, (double)riftPos.method_10263(), (double)riftPos.method_10264(), (double)riftPos.method_10260(), class_3417.field_14671, class_3419.field_15254, 400.0f, 1.0f);
    }

    private static void spawnRiftGuardians(class_3218 world, class_2338 pos) {
        double spawnZ;
        double spawnY;
        double spawnX;
        class_1634 mob;
        if (RANDOM.nextBoolean()) {
            mob = new class_1634(class_1299.field_6059, (class_1937)world);
            spawnX = (double)pos.method_10263() + 0.5 + (RANDOM.nextDouble() - 0.5) * 3.0;
            spawnY = (double)pos.method_10264() + 1.0;
            spawnZ = (double)pos.method_10260() + 0.5 + (RANDOM.nextDouble() - 0.5) * 3.0;
        } else {
            mob = new class_1593(class_1299.field_6078, (class_1937)world);
            spawnX = (double)pos.method_10263() + 0.5 + (RANDOM.nextDouble() - 0.5) * 10.0;
            spawnY = (double)pos.method_10264() + 10.0 + RANDOM.nextDouble() * 5.0;
            spawnZ = (double)pos.method_10260() + 0.5 + (RANDOM.nextDouble() - 0.5) * 10.0;
        }
        mob.method_23327(spawnX, spawnY, spawnZ);
        mob.method_5971();
        mob.method_5665((class_2561)class_2561.method_43470((String)"Rift Guardian").method_27692(class_124.field_1061));
        mob.method_5880(true);
        world.method_8649((class_1297)mob);
    }

    private static void spawnRiftParticles(MinecraftServer server, Rift rift) {
        class_3218 world = server.method_3847(rift.dimension);
        if (world == null) {
            return;
        }
        double x = (double)rift.position.method_10263() + 0.5;
        double y = (double)rift.position.method_10264() + 1.5;
        double z = (double)rift.position.method_10260() + 0.5;
        float multiplier = 1.0f;
        if (rift.dropTimer < 1200) {
            float progress = (float)(1200 - rift.dropTimer) / 1200.0f;
            multiplier = 1.0f + progress * 4.0f;
        }
        int particleCount = (int)(30.0f * multiplier);
        for (int i = 0; i < particleCount; ++i) {
            double time = (double)rift.dropTimer + (double)i * 0.1;
            double spiralAngle = time * 0.15;
            double spiralRadius = 0.5 * (1.0 - Math.abs(Math.sin(time * 0.05)));
            double spawnX = x + spiralRadius * Math.cos(spiralAngle);
            double spawnZ = z + spiralRadius * Math.sin(spiralAngle);
            double spawnY = y + RANDOM.nextDouble() * 1.0;
            double velocityX = (x - spawnX) * 0.2 + RANDOM.nextDouble() * 0.1 - 0.05;
            double velocityY = 0.01 + 0.05 * (double)multiplier;
            double velocityZ = (z - spawnZ) * 0.2 + RANDOM.nextDouble() * 0.1 - 0.05;
            world.method_14199((class_2394)class_2398.field_23190, spawnX, spawnY, spawnZ, 0, velocityX, velocityY, velocityZ, 1.0);
            world.method_14199((class_2394)class_2398.field_22246, spawnX, spawnY, spawnZ, 0, velocityX * 0.5, velocityY * 1.5, velocityZ * 0.5, 1.0);
        }
        int baseParticles = 80;
        world.method_14199((class_2394)class_2398.field_11214, x, y, z, (int)((float)baseParticles * multiplier), 0.25, 0.25, 0.25, 0.8);
        double helixRadius = 3.0;
        double helixHeight = 10.0;
        double helixTurns = 2.5;
        double helixSpeed = 0.2;
        double timeBase = (double)world.method_8510() * 0.2;
        double progress = timeBase % (Math.PI * 2) / (Math.PI * 2);
        double currentHelixAngle = timeBase * 2.5;
        double currentHelixHeightProgress = timeBase * 0.6366197723675814 % 10.0;
        double normalizedTime = (double)world.method_8510() * 0.2 / (Math.PI * 2);
        double currentY1 = y + 1.0 + normalizedTime * 10.0 % 10.0;
        double currentY2 = y + 1.0 + normalizedTime * 10.0 % 10.0;
        double angle1 = (double)world.method_8510() * 0.1 % (Math.PI * 2);
        double currentYHeight1 = (double)world.method_8510() * 0.05 % 10.0;
        double strand1X = x + 3.0 * Math.cos(angle1);
        double strand1Z = z + 3.0 * Math.sin(angle1);
        world.method_14199((class_2394)class_2398.field_11207, strand1X, y + 1.0 + currentYHeight1, strand1Z, 0, 0.0, 0.0, 0.0, 1.0);
        double angle2 = ((double)world.method_8510() * 0.1 + Math.PI) % (Math.PI * 2);
        double currentYHeight2 = ((double)world.method_8510() * 0.05 + 5.0) % 10.0;
        double strand2X = x + 3.0 * Math.cos(angle2);
        double strand2Z = z + 3.0 * Math.sin(angle2);
        world.method_14199((class_2394)class_2398.field_11207, strand2X, y + 1.0 + currentYHeight2, strand2Z, 0, 0.0, 0.0, 0.0, 1.0);
        baseParticles = 2;
        world.method_14199((class_2394)class_2398.field_38004, x, y + 0.5, z, (int)((float)baseParticles * multiplier), 10.0, 1.0, 10.0, 0.05);
        baseParticles = 100;
        double swirlY = rift.position.method_10264() + 20;
        for (int i = 0; i < (int)((float)baseParticles * multiplier); ++i) {
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double radius = RANDOM.nextDouble() * 15.0;
            double spawnX = x + radius * Math.cos(angle);
            double spawnZ = z + radius * Math.sin(angle);
            double velocityMagnitude = 0.5 + 0.5 * (double)multiplier;
            double velocityX = -Math.sin(angle) * velocityMagnitude * (radius / 15.0);
            double velocityZ = Math.cos(angle) * velocityMagnitude * (radius / 15.0);
            double velocityY = -0.05;
            world.method_14199((class_2394)class_2398.field_11214, spawnX, swirlY + (RANDOM.nextDouble() * 5.0 - 2.5), spawnZ, 0, velocityX, velocityY, velocityZ, 1.0);
        }
    }

    private static class_2338 findRandomSurfacePos(class_3218 world) {
        int z;
        int x;
        class_2338 topPos;
        class_2338 spawnPos = world.method_43126();
        int attempts = 0;
        int MAX_ATTEMPTS = 100;
        while ((topPos = world.method_8598(class_2902.class_2903.field_13202, new class_2338(x = spawnPos.method_10263() + (RANDOM.nextInt(5000) - 2500), 0, z = spawnPos.method_10260() + (RANDOM.nextInt(5000) - 2500)))).method_10264() <= 60 && ++attempts < 100) {
        }
        if (attempts == 100 && topPos.method_10264() <= 60) {
            System.err.println("DimensionalRiftItem: Could not find a natural surface above Y=60 after 100 attempts. Forcing position.");
            topPos = new class_2338(topPos.method_10263(), 61, topPos.method_10260());
        }
        return topPos.method_10086(3);
    }

    private static void announceRift(MinecraftServer server, class_2338 pos) {
        class_5250 message = class_2561.method_43470((String)"=======================================\n").method_27692(class_124.field_1074).method_10852((class_2561)class_2561.method_43470((String)"[Heartless Industries] A dimensional Shift has opened!").method_27695(new class_124[]{class_124.field_1067, class_124.field_1061})).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"Coordinates: ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260())).method_27692(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"Some Artifacts will manifest in 5 minutes!").method_27692(class_124.field_1054)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"=======================================").method_27692(class_124.field_1074));
        server.method_3760().method_43514((class_2561)message, false);
    }

    private static void dropItemAtRift(MinecraftServer server, Rift rift) {
        class_3218 world = server.method_3847(rift.dimension);
        if (world == null) {
            return;
        }
        double x = (double)rift.position.method_10263() + 0.5;
        double y = (double)rift.position.method_10264() + 1.5;
        double z = (double)rift.position.method_10260() + 0.5;
        world.method_14199((class_2394)class_2398.field_11221, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        world.method_14199((class_2394)class_2398.field_17909, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        world.method_14199((class_2394)class_2398.field_11214, x, y, z, 200, 3.0, 3.0, 3.0, 0.5);
        for (class_1799 stack : RIFT_REWARD_ITEMS) {
            world.method_8649((class_1297)new class_1542((class_1937)world, x, y, z, stack.method_7972()));
        }
        class_5250 message = class_2561.method_43470((String)"[Heartless Industries] ").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"The artifacts have stabilized and dropped at the rift location!").method_27692(class_124.field_1060));
        server.method_3760().method_43514((class_2561)message, false);
        world.method_43128(null, (double)rift.position.method_10263(), (double)rift.position.method_10264(), (double)rift.position.method_10260(), class_3417.field_14941, class_3419.field_15254, 10.0f, 1.5f);
    }

    private static class Rift {
        final class_2338 position;
        final class_5321<class_1937> dimension;
        int dropTimer;

        Rift(class_2338 pos, class_5321<class_1937> dim) {
            this.position = pos;
            this.dimension = dim;
            this.dropTimer = 6000;
        }
    }
}

