/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal.entity.custom;

import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.heartless.heartless_arsonal.HeartlessArsonal;
import net.heartless.heartless_arsonal.entity.ModEntities;
import net.heartless.heartless_arsonal.item.ModItems;
import net.heartless.heartless_arsonal.item.custom.WarturtleArmorItem;
import net.heartless.heartless_arsonal.screen.custom.WarturtleScreenHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5815;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class WarturtleEntity
extends class_1321
implements class_1265,
class_7248 {
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public final class_7094 sittingTransitionAnimationState = new class_7094();
    public final class_7094 sittingAnimationState = new class_7094();
    public final class_7094 standingTransitionAnimationState = new class_7094();
    public static final class_2940<Long> LAST_POSE_TICK = class_2945.method_12791(WarturtleEntity.class, (class_2941)class_2943.field_39965);
    public static final class_2940<Boolean> HAS_TIER_1_CHEST = class_2945.method_12791(WarturtleEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_TIER_2_CHEST = class_2945.method_12791(WarturtleEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_TIER_3_CHEST = class_2945.method_12791(WarturtleEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_1799> DYE_STACK = class_2945.method_12791(WarturtleEntity.class, (class_2941)class_2943.field_13322);
    protected class_1277 inventory;
    private final int TIER_1_CHEST_SLOT = 2;
    private final int TIER_2_CHEST_SLOT = 3;
    private final int TIER_3_CHEST_SLOT = 4;

    public WarturtleEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.createInventory();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.15));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{ModItems.BLOOD_CRYSTAL}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.1, 10.0f, 3.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createWarturtleAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 45.0).method_26868(class_5134.field_23719, (double)0.15f).method_26868(class_5134.field_23721, 1.0);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(ModItems.BLOOD_CRYSTAL);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.WARTURTLE.method_5883((class_1937)world);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 20;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.shouldUpdateSittingAnimations()) {
            this.standingTransitionAnimationState.method_41325();
            if (this.shouldPlaySittingTransitionAnimation()) {
                this.sittingTransitionAnimationState.method_41324(this.field_6012);
                this.sittingAnimationState.method_41325();
            } else {
                this.sittingTransitionAnimationState.method_41325();
                this.sittingAnimationState.method_41324(this.field_6012);
            }
        } else {
            this.sittingTransitionAnimationState.method_41325();
            this.sittingAnimationState.method_41325();
            this.standingTransitionAnimationState.method_45317(this.isChangingPose() && this.getLastPoseTickDelta() >= 0L, this.field_6012);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    private boolean shouldPlaySittingTransitionAnimation() {
        return this.method_24345() && this.getLastPoseTickDelta() < 40L && this.getLastPoseTickDelta() >= 0L;
    }

    public boolean shouldUpdateSittingAnimations() {
        return this.getLastPoseTickDelta() < 0L != this.method_24345();
    }

    public long getLastPoseTickDelta() {
        return this.method_37908().method_8510() - Math.abs((Long)this.field_6011.method_12789(LAST_POSE_TICK));
    }

    public boolean isChangingPose() {
        long l = this.getLastPoseTickDelta();
        return l < (long)(this.method_24345() ? 40 : 52);
    }

    public void setLastPoseTick(long lastPoseTick) {
        this.field_6011.method_12778(LAST_POSE_TICK, (Object)lastPoseTick);
    }

    private void initLastPoseTick(long time) {
        this.setLastPoseTick(Math.max(0L, time - 52L - 1L));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LAST_POSE_TICK, (Object)0L);
        builder.method_56912(HAS_TIER_1_CHEST, (Object)false);
        builder.method_56912(HAS_TIER_2_CHEST, (Object)false);
        builder.method_56912(HAS_TIER_3_CHEST, (Object)false);
        builder.method_56912(DYE_STACK, (Object)class_1799.field_8037);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10544("LastPoseTick", ((Long)this.field_6011.method_12789(LAST_POSE_TICK)).longValue());
        class_2499 listtag = new class_2499();
        for (int x = 0; x < this.inventory.method_5439(); ++x) {
            class_1799 itemstack = this.inventory.method_5438(x);
            if (itemstack.method_7960()) continue;
            class_2487 compoundtag = new class_2487();
            compoundtag.method_10567("Slot", (byte)x);
            listtag.add((Object)itemstack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)compoundtag));
        }
        nbt.method_10566("Items", (class_2520)listtag);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        long l = nbt.method_10537("LastPoseTick");
        if (l < 0L) {
            this.method_18380(class_4050.field_40118);
        }
        this.setLastPoseTick(l);
        this.createInventory();
        class_2499 listtag = nbt.method_10554("Items", 10);
        for (int x = 0; x < listtag.size(); ++x) {
            class_2487 compoundtag = listtag.method_10602(x);
            int j = compoundtag.method_10571("Slot") & 0xFF;
            if (j >= this.inventory.method_5439()) continue;
            this.inventory.method_5447(j, class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compoundtag).orElse(class_1799.field_8037));
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.initLastPoseTick(world.method_8410().method_8510());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void toggleSitting() {
        if (this.method_24345()) {
            this.startStanding();
        } else {
            this.startSitting();
        }
    }

    public void startSitting() {
        if (this.method_24345()) {
            return;
        }
        this.method_56078(class_3417.field_40079);
        this.method_18380(class_4050.field_40118);
        this.method_32876((class_6880)class_5712.field_45148);
        this.setLastPoseTick(-this.method_37908().method_8510());
        this.method_6179(true);
        this.method_24346(true);
    }

    public void startStanding() {
        if (!this.method_24345()) {
            return;
        }
        this.method_56078(class_3417.field_40080);
        this.method_18380(class_4050.field_18076);
        this.method_32876((class_6880)class_5712.field_45148);
        this.setLastPoseTick(this.method_37908().method_8510());
        this.method_6179(false);
        this.method_24346(false);
    }

    public boolean method_24345() {
        return (Long)this.field_6011.method_12789(LAST_POSE_TICK) < 0L;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1792 itemForTaming;
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (item == (itemForTaming = class_1802.field_8279) && !this.method_6181()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            super.method_6170(player);
            this.field_6189.method_6356();
            this.method_5980(null);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            this.toggleSitting();
            return class_1269.field_5812;
        }
        if (this.method_6181() && hand == class_1268.field_5808 && item != itemForTaming && !this.method_6481(itemstack) && !player.method_21823()) {
            this.toggleSitting();
            return class_1269.field_5812;
        }
        if (this.method_6181()) {
            this.method_6722(player);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_5453(class_1263 sender) {
        if (sender.method_5438(2).method_31574(class_1802.field_8106) && !this.hasTier1Chest()) {
            this.setChest(2, true);
        }
        if (sender.method_5438(3).method_31574(class_1802.field_8106) && !this.hasTier2Chest()) {
            this.setChest(3, true);
        }
        if (sender.method_5438(4).method_31574(class_1802.field_8106) && !this.hasTier3Chest()) {
            this.setChest(4, true);
        }
        if (!sender.method_5438(2).method_31574(class_1802.field_8106) && this.hasTier1Chest()) {
            this.setChest(2, false);
            this.dropChestInventory(2);
        }
        if (!sender.method_5438(3).method_31574(class_1802.field_8106) && this.hasTier2Chest()) {
            this.setChest(3, false);
            this.dropChestInventory(3);
        }
        if (!sender.method_5438(4).method_31574(class_1802.field_8106) && this.hasTier3Chest()) {
            this.setChest(4, false);
            this.dropChestInventory(4);
        }
        if (sender.method_5438(0).method_7909() instanceof WarturtleArmorItem) {
            this.method_56678(sender.method_5438(0));
        }
        if (sender.method_5438(0).method_7960() && this.method_56677()) {
            this.method_56678(class_1799.field_8037);
        }
        if (!sender.method_5438(1).method_7960()) {
            this.field_6011.method_12778(DYE_STACK, (Object)sender.method_5438(1));
        }
        if (sender.method_5438(1).method_7960()) {
            this.field_6011.method_12778(DYE_STACK, (Object)class_1799.field_8037);
        }
    }

    private void dropChestInventory(int slot) {
        if (slot == 2) {
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(5, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(6, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(7, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(8, 64));
        }
        if (slot == 3) {
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(9, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(10, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(11, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(12, 64));
        }
        if (slot == 4) {
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(13, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(14, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(15, 64));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)(this.method_23318() + 1.0), (double)this.method_23321(), (class_1799)this.inventory.method_5434(16, 64));
        }
    }

    public void setChest(int slot, boolean chested) {
        if (slot == 2) {
            this.field_6011.method_12778(HAS_TIER_1_CHEST, (Object)chested);
        } else if (slot == 3) {
            this.field_6011.method_12778(HAS_TIER_2_CHEST, (Object)chested);
        } else if (slot == 4) {
            this.field_6011.method_12778(HAS_TIER_3_CHEST, (Object)chested);
        } else {
            HeartlessArsonal.LOGGER.error("Can't give chest to a Slot that doesn't exist!");
        }
    }

    public boolean hasTier1Chest() {
        return (Boolean)this.field_6011.method_12789(HAS_TIER_1_CHEST);
    }

    public boolean hasTier2Chest() {
        return (Boolean)this.field_6011.method_12789(HAS_TIER_2_CHEST);
    }

    public boolean hasTier3Chest() {
        return (Boolean)this.field_6011.method_12789(HAS_TIER_3_CHEST);
    }

    protected void createInventory() {
        class_1277 simpleInventory = this.inventory;
        this.inventory = new class_1277(this.getInventorySize());
        if (simpleInventory != null) {
            simpleInventory.method_5488((class_1265)this);
            int i = Math.min(simpleInventory.method_5439(), this.inventory.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemStack = simpleInventory.method_5438(j);
                if (itemStack.method_7960()) continue;
                this.inventory.method_5447(j, itemStack.method_7972());
            }
        }
        this.inventory.method_5489((class_1265)this);
    }

    public final int getInventorySize() {
        return WarturtleEntity.getInventorySize(4);
    }

    public static int getInventorySize(int columns) {
        return columns * 3 + 5;
    }

    public boolean areInventoriesDifferent(class_1263 inventory) {
        return this.inventory != inventory;
    }

    public void method_6722(class_1657 player) {
        if (!this.method_37908().method_8608() && this.method_6181()) {
            class_3222 serverPlayer = (class_3222)player;
            if (serverPlayer.field_7512 != serverPlayer.field_7498) {
                serverPlayer.method_7346();
            }
            serverPlayer.method_17355((class_3908)new ExtendedScreenHandlerFactory<UUID>(){

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                    return new WarturtleScreenHandler(syncId, playerInventory, (class_1263)WarturtleEntity.this.inventory, WarturtleEntity.this, 4);
                }

                public class_2561 method_5476() {
                    return class_2561.method_43470((String)"Warturtle");
                }

                public UUID getScreenOpeningData(class_3222 player) {
                    return WarturtleEntity.this.method_5667();
                }
            });
        }
    }

    public boolean hasArmorOn() {
        return this.method_56677();
    }

    protected void method_6074(class_1282 source, float amount) {
        if (!this.canArmorAbsorb(source)) {
            super.method_6074(source, amount);
        } else {
            class_1799 itemstack = this.method_56676();
            itemstack.method_7970(class_3532.method_15386((float)amount), (class_1309)this, class_1304.field_48824);
            class_1792 class_17922 = itemstack.method_7909();
            if (class_17922 instanceof WarturtleArmorItem) {
                WarturtleArmorItem warturtleArmorItem = (WarturtleArmorItem)class_17922;
                int damagereducton = warturtleArmorItem.method_7687() / 2;
                super.method_6074(source, Math.max(0.0f, amount - (float)damagereducton));
            }
        }
    }

    private boolean canArmorAbsorb(class_1282 damageSource) {
        return this.hasArmorOn() && !damageSource.method_48789(class_8103.field_49182);
    }

    @Nullable
    private static class_1767 getDyeColor(class_1799 stack) {
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        return block instanceof class_5815 ? ((class_5815)block).method_33635() : null;
    }

    @Nullable
    public class_1767 getSwag() {
        return WarturtleEntity.getDyeColor((class_1799)this.field_6011.method_12789(DYE_STACK));
    }
}

