/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal.item.custom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1679;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ShieldRingManager {
    private static final Map<UUID, Long> activeShields = new HashMap<UUID, Long>();
    private static final long DURATION_MS = 5000L;

    public static void activateShield(class_1657 player) {
        activeShields.put(player.method_5667(), System.currentTimeMillis());
    }

    public static boolean isShieldActive(class_1657 player) {
        Long start = activeShields.get(player.method_5667());
        if (start == null) {
            return false;
        }
        if (System.currentTimeMillis() - start > 5000L) {
            activeShields.remove(player.method_5667());
            return false;
        }
        return true;
    }

    public static void register() {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = world;
            Iterator<Map.Entry<UUID, Long>> iterator = activeShields.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Long> entry = iterator.next();
                class_1657 player = serverWorld.method_18470(entry.getKey());
                if (player == null || !ShieldRingManager.isShieldActive(player)) {
                    iterator.remove();
                    continue;
                }
                ShieldRingManager.spawnRingParticles(serverWorld, player);
                ShieldRingManager.reflectAndBlockProjectiles(serverWorld, player);
            }
        });
    }

    private static void spawnRingParticles(class_3218 world, class_1657 player) {
        class_243 center = player.method_19538();
        double radius = 2.5;
        double y = center.field_1351 + 1.0;
        for (int i = 0; i < 360; i += 15) {
            double radians = Math.toRadians(i);
            double x = center.field_1352 + Math.cos(radians) * radius;
            double z = center.field_1350 + Math.sin(radians) * radius;
            world.method_14199((class_2394)class_2398.field_11215, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void reflectAndBlockProjectiles(class_3218 world, class_1657 player) {
        class_238 box = player.method_5829().method_1014(2.5);
        List projectiles = world.method_8390(class_1665.class, box, e -> true);
        for (class_1665 original : projectiles) {
            class_243 velocity = original.method_18798().method_1021(-1.5);
            class_243 spawnPos = original.method_19538();
            class_1665 reflected = null;
            if (original instanceof class_1667) {
                reflected = (class_1665)class_1299.field_6122.method_5883((class_1937)world);
            } else if (original instanceof class_1679) {
                reflected = (class_1665)class_1299.field_6135.method_5883((class_1937)world);
            }
            if (reflected == null) continue;
            reflected.method_33574(spawnPos);
            reflected.method_18799(velocity);
            reflected.method_7432((class_1297)player);
            reflected.field_7572 = class_1665.class_1666.field_7592;
            original.method_31472();
            world.method_8649((class_1297)reflected);
            world.method_14199((class_2394)class_2398.field_11205, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, 5, 0.1, 0.1, 0.1, 0.2);
        }
    }
}

