/*
 * Decompiled with CFR 0.152.
 */
package net.heartless.heartless_arsonal.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.nitron.nitrogen.util.interfaces.ColorableItem;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class ZweiSwordItem
extends class_1829
implements ColorableItem {
    public static final int COOLDOWN_TICKS = 200;
    public static final float SLASH_DAMAGE = 8.0f;
    public static final double ATTACK_RANGE = 5.5;
    public static final double ATTACK_WIDTH = 3.0;
    public static final double SLASH_SEPARATION = 1.0;
    public static final float SLAM_DAMAGE = 8.0f;
    public static final double SLAM_RADIUS = 10.0;
    public static final float BASE_KNOCKBACK_POWER = -30.5f;
    public static final float KNOCKBACK_PER_FALL_METER = 0.5f;
    public static final String MODE_SLASH = "TRIPLE SLASH";
    public static final String MODE_SLAM = "GROUND SLAM";
    private static final Map<UUID, String> MODE_MAP = new WeakHashMap<UUID, String>();

    public ZweiSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
    }

    private String getCurrentMode(class_1657 user) {
        return MODE_MAP.getOrDefault(user.method_5667(), MODE_SLASH);
    }

    private void setMode(class_1657 user, String mode) {
        MODE_MAP.put(user.method_5667(), mode);
    }

    private void performSlam(class_1937 world, class_1657 user, class_1268 hand) {
        class_243 userPos = user.method_19538();
        float fallDistance = user.field_6017;
        float knockbackBonus = fallDistance * 0.5f;
        float effectiveKnockbackPower = -30.5f + knockbackBonus;
        class_238 slamBox = user.method_5829().method_1009(10.0, 1.0, 10.0);
        List targets = world.method_8390(class_1309.class, slamBox, entity -> entity != user && entity.method_5805());
        if (targets.isEmpty()) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_15203, class_3419.field_15248, 1.0f, 0.5f);
        } else {
            world.method_60511(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 2.0f, 0.8f);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)class_2398.field_11221, userPos.field_1352, userPos.field_1351, userPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        class_1282 damageSource = world.method_48963().method_48802(user);
        for (class_1309 target : targets) {
            target.method_5643(damageSource, 8.0f);
            class_243 knockbackVector = target.method_19538().method_1020(userPos).method_1029();
            float finalKnockback = Math.abs(effectiveKnockbackPower);
            target.method_6005((double)finalKnockback, knockbackVector.field_1352, knockbackVector.field_1350);
        }
        user.method_23667(hand, true);
        user.field_6017 = 0.0f;
    }

    private void performSlash(class_1937 world, class_1657 user, class_1268 hand, float xOffset) {
        List<class_1309> targets = this.findTargets(world, user, xOffset);
        if (targets.isEmpty()) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.0f);
        } else {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.2f);
        }
        class_1282 damageSource = world.method_48963().method_48802(user);
        for (class_1309 target : targets) {
            if (target.method_5805()) {
                target.method_5643(damageSource, 8.0f);
            }
            if (!(world instanceof class_3218)) continue;
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)class_2398.field_11227, target.method_23317(), target.method_23323(0.5), target.method_23321(), 3, 0.5, 0.5, 0.5, 0.0);
        }
        user.method_23667(hand, true);
    }

    private List<class_1309> findTargets(class_1937 world, class_1657 user, float xOffset) {
        class_243 lookVec = user.method_5720();
        class_243 sideVec = lookVec.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        class_243 offsetVector = sideVec.method_1021((double)xOffset * 1.0);
        class_243 startPos = user.method_33571().method_1019(offsetVector);
        class_243 endPos = user.method_33571().method_1019(lookVec.method_1021(5.5)).method_1019(offsetVector);
        class_238 attackBox = new class_238(startPos, endPos).method_1009(1.5, 1.5, 1.5);
        return world.method_8390(class_1309.class, attackBox, entity -> !entity.method_5722((class_1297)user) && entity != user && user.method_6057((class_1297)entity));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            if (user.method_5715()) {
                String currentMode = this.getCurrentMode(user);
                String newMode = currentMode.equals(MODE_SLASH) ? MODE_SLAM : MODE_SLASH;
                this.setMode(user, newMode);
                user.method_7353((class_2561)class_2561.method_43470((String)("Switched mode to: " + newMode)).method_27692(class_124.field_1075), true);
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_23118, class_3419.field_15248, 0.8f, 1.5f);
                return class_1271.method_22427((Object)stack);
            }
            if (user.method_7357().method_7904((class_1792)this)) {
                user.method_7353((class_2561)class_2561.method_43470((String)"Ability on cooldown!").method_27692(class_124.field_1061), true);
                return class_1271.method_22431((Object)stack);
            }
            String currentMode = this.getCurrentMode(user);
            user.method_7357().method_7906((class_1792)this, 200);
            if (currentMode.equals(MODE_SLAM)) {
                this.performSlam(world, user, hand);
            } else {
                this.performSlash(world, user, hand, -1.0f);
                this.performSlash(world, user, hand, 0.0f);
                this.performSlash(world, user, hand, 1.0f);
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
    }

    public int startColor(class_1799 itemStack) {
        return -8323017;
    }

    public int endColor(class_1799 itemStack) {
        return -8323017;
    }

    public int backgroundColor(class_1799 itemStack) {
        return -264962021;
    }
}

